/*
 * Decompiled with CFR 0.152.
 */
package eu.midnightdust.midnightcontrols.packet;

import eu.midnightdust.midnightcontrols.MidnightControlsConstants;
import eu.midnightdust.midnightcontrols.MidnightControlsFeature;
import java.util.Optional;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;

public record FeaturePayload(MidnightControlsFeature[] features) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<FeaturePayload> PACKET_ID = new CustomPacketPayload.Type(MidnightControlsConstants.FEATURE_CHANNEL);
    public static final StreamCodec<RegistryFriendlyByteBuf, FeaturePayload> codec = StreamCodec.ofMember(FeaturePayload::write, FeaturePayload::read);

    public static FeaturePayload read(RegistryFriendlyByteBuf buf) {
        int featureLength = buf.readVarInt();
        MidnightControlsFeature[] receivedFeatures = new MidnightControlsFeature[featureLength];
        for (int i = 0; i < featureLength; ++i) {
            String name = buf.readUtf(64);
            boolean allowed = buf.readBoolean();
            Optional<MidnightControlsFeature> feature = MidnightControlsFeature.fromName(name);
            if (!feature.isPresent()) continue;
            feature.get().setAllowed(allowed);
            receivedFeatures[i] = feature.get();
        }
        return new FeaturePayload(receivedFeatures);
    }

    public void write(RegistryFriendlyByteBuf buf) {
        if (this.features.length == 0) {
            throw new IllegalArgumentException("At least one feature must be provided.");
        }
        buf.writeVarInt(this.features.length);
        for (MidnightControlsFeature feature : this.features) {
            buf.writeUtf(feature.getName(), 64);
            buf.writeBoolean(feature.isAllowed());
        }
    }

    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return PACKET_ID;
    }
}

