/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.core.backups;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.backups.BackupCheckEnum;
import computer.heather.advancedbackups.core.backups.ThreadedBackup;
import computer.heather.advancedbackups.core.backups.gson.BackupManifest;
import computer.heather.advancedbackups.core.config.ConfigManager;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.Date;
import java.util.function.Consumer;

public class BackupWrapper {
    private static GsonBuilder builder = new GsonBuilder();
    private static Gson gson = builder.setPrettyPrinting().create();
    public static ArrayList<Long> configuredPlaytime = new ArrayList();

    public static void checkStartupBackups() {
        BackupWrapper.prepareBackupDestination();
        ABCore.enableSaving(true);
        File file = new File(ABCore.backupPath);
        File backupManifest = new File(file, "manifest.json");
        if (backupManifest.exists()) {
            try {
                try {
                    BackupManifest manifest = (BackupManifest)gson.fromJson(new String(Files.readAllBytes(backupManifest.toPath())), BackupManifest.class);
                    ABCore.activity = manifest.general.activity;
                }
                catch (JsonParseException e) {
                    ABCore.errorLogger.accept("Malformed backup manifest! Will be completely replaced, and will assume player activity has changed...");
                    BackupManifest manifest = BackupManifest.defaults();
                    manifest.general.activity = true;
                    ABCore.activity = true;
                    FileWriter writer = new FileWriter(backupManifest);
                    writer.write(gson.toJson((Object)manifest));
                    writer.flush();
                    writer.close();
                }
            }
            catch (IOException e) {
                ABCore.errorLogger.accept("Error reading player actiivty from backup manifest!!");
                ABCore.logStackTrace(e);
            }
        }
        if (ConfigManager.startup.get().booleanValue()) {
            BackupWrapper.checkAndMakeBackups(Math.max(5000L, ConfigManager.delay.get() * 1000L), false);
        }
    }

    public static void checkShutdownBackups() {
        if (ConfigManager.shutdown.get().booleanValue()) {
            BackupWrapper.checkAndMakeBackups(0L, true);
        }
    }

    public static void checkAndMakeBackups(long delay, boolean shutdown) {
        BackupCheckEnum e = BackupWrapper.checkBackups();
        if (e.success()) {
            BackupWrapper.makeSingleBackup(delay, shutdown);
        }
    }

    public static void checkAndMakeBackups() {
        BackupWrapper.checkAndMakeBackups(0L, false);
    }

    public static BackupCheckEnum checkBackups() {
        if (!ConfigManager.enabled.get().booleanValue()) {
            return BackupCheckEnum.DISABLED;
        }
        if (ConfigManager.activity.get().booleanValue() && !ABCore.activity.booleanValue()) {
            return BackupCheckEnum.NOACTIVITY;
        }
        if (BackupWrapper.checkMostRecentBackup()) {
            return BackupCheckEnum.TOORECENT;
        }
        return BackupCheckEnum.SUCCESS;
    }

    private static void prepareBackupDestination() {
        File backupManifest;
        File snapshots;
        File incremental;
        File differential;
        File file = new File(ABCore.backupPath);
        if (!file.exists()) {
            file.mkdirs();
        }
        BackupWrapper.prepareReadMe(file);
        BackupWrapper.prepareRestorationScripts(file);
        File zipFile = new File(file, "/zips/");
        if (!zipFile.exists()) {
            zipFile.mkdirs();
        }
        if (!(differential = new File(file, "/differential/")).exists()) {
            differential.mkdirs();
        }
        if (!(incremental = new File(file, "/incremental/")).exists()) {
            incremental.mkdirs();
        }
        if (!(snapshots = new File(file, "/snapshots/")).exists()) {
            snapshots.mkdirs();
        }
        if (!(backupManifest = new File(file, "manifest.json")).exists()) {
            try {
                backupManifest.createNewFile();
                BackupManifest manifest = BackupManifest.defaults();
                FileWriter writer = new FileWriter(backupManifest);
                writer.write(gson.toJson((Object)manifest));
                writer.flush();
                writer.close();
            }
            catch (IOException e) {
                ABCore.errorLogger.accept("Error initialising backup manifest!!");
                ABCore.logStackTrace(e);
            }
        }
    }

    private static void prepareReadMe(File path) {
        File readme = new File(path.getParent(), "README-BEFORE-RESTORING.txt");
        if (!readme.exists()) {
            try {
                int n;
                InputStream is = BackupWrapper.class.getClassLoader().getResourceAsStream("advancedbackups-readme.txt");
                readme.createNewFile();
                FileOutputStream outputStream = new FileOutputStream(readme);
                byte[] buf = new byte[1028];
                while ((n = is.read(buf)) > 0) {
                    outputStream.write(buf, 0, n);
                }
                outputStream.flush();
                outputStream.close();
            }
            catch (IOException e) {
                ABCore.logStackTrace(e);
            }
        }
    }

    private static void prepareRestorationScripts(File path) {
        try {
            String dir = ABCore.modJar.getParent();
            String file = ABCore.modJar.getName();
            File script = new File(path.getParent(), "restore-script.bat");
            if (script.exists()) {
                script.delete();
            }
            script.createNewFile();
            FileWriter writer = new FileWriter(script);
            writer.append("@echo off \n");
            writer.append(dir.charAt(0) + ":\n");
            writer.append("cd \"" + dir + "\"\n");
            writer.append("java -jar \"" + file + "\"\n");
            writer.append("pause\n");
            writer.flush();
            writer.close();
            script = new File(path.getParent(), "restore-script.sh");
            if (script.exists()) {
                script.delete();
            }
            script.createNewFile();
            writer = new FileWriter(script);
            writer.append("cd \"" + dir + "\"\n");
            writer.append("java -jar \"" + file + "\"\n");
            writer.flush();
            writer.close();
        }
        catch (IOException e) {
            ABCore.errorLogger.accept("Error writing restoration scripts! Manual running of jar will still work.");
            ABCore.logStackTrace(e);
        }
    }

    public static boolean checkMostRecentBackup() {
        if (ConfigManager.minFrequency.get().floatValue() <= 0.0f) {
            return false;
        }
        Date date = new Date();
        long configVal = (long)(3600000.0f * ConfigManager.minFrequency.get().floatValue());
        return date.getTime() - BackupWrapper.mostRecentBackupTime() < configVal;
    }

    public static long mostRecentBackupTime() {
        File directory = new File(ABCore.backupPath);
        switch (ConfigManager.type.get()) {
            case "zip": {
                directory = new File(directory, "/zips/");
                break;
            }
            case "differential": {
                directory = new File(directory, "/differential/");
                break;
            }
            case "incremental": {
                directory = new File(directory, "/incremental/");
            }
        }
        File[] files = directory.listFiles();
        long lastModifiedTime = Long.MIN_VALUE;
        if (files == null || files.length == 0) {
            return 0L;
        }
        for (File file : files) {
            if (file.lastModified() <= lastModifiedTime || file.getName().contains("manifest")) continue;
            lastModifiedTime = file.lastModified();
        }
        return lastModifiedTime;
    }

    public static void makeSingleBackup(long delay, boolean shutdown) {
        BackupWrapper.makeSingleBackup(delay, s -> {}, shutdown);
    }

    public static void makeSingleBackup(long delay, Consumer<String> output, boolean shutdown) {
        try {
            if (!shutdown) {
                ABCore.disableSaving();
                if (ConfigManager.save.get().booleanValue()) {
                    ABCore.saveOnce();
                }
            }
        }
        catch (Exception e) {
            ABCore.errorLogger.accept("Error saving or disabling saving!");
            ABCore.logStackTrace(e);
        }
        if (ThreadedBackup.running) {
            ABCore.errorLogger.accept("Backup already running!");
            ABCore.logStackTrace(new Exception());
            return;
        }
        ThreadedBackup.running = true;
        ThreadedBackup threadedBackup = new ThreadedBackup(delay, output);
        if (shutdown) {
            threadedBackup.shutdown();
        }
        threadedBackup.start();
    }

    public static void makeSnapshot(Consumer<String> output, String snapshotName) {
        ABCore.disableSaving();
        if (ConfigManager.save.get().booleanValue()) {
            ABCore.saveOnce();
        }
        if (ThreadedBackup.running) {
            ABCore.errorLogger.accept("Backup already running!");
            ABCore.logStackTrace(new Exception());
            return;
        }
        ThreadedBackup.running = true;
        ThreadedBackup threadedBackup = new ThreadedBackup(5000L, output);
        threadedBackup.snapshot(snapshotName);
        threadedBackup.start();
    }

    public static void finishBackup(boolean snapshot) {
        ABCore.resetActivity();
        if (snapshot) {
            return;
        }
        File directory = new File(ABCore.backupPath);
        switch (ConfigManager.type.get()) {
            case "zip": {
                directory = new File(directory, "/zips/");
                break;
            }
            case "differential": {
                directory = new File(directory, "/differential/");
                break;
            }
            case "incremental": {
                directory = new File(directory, "/incremental/");
            }
        }
        BackupWrapper.checkSize(directory);
        BackupWrapper.checkCount(directory);
        BackupWrapper.checkDates(directory);
    }

    public static File getDependent(File in) {
        File file = BackupWrapper.getFirstBackupAfterDate(in.getParentFile(), in.lastModified());
        if (file.getName().contains("-partial")) {
            return file;
        }
        return null;
    }

    public static long calculateDirectorySize(File directory) {
        long size = 0L;
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            return size;
        }
        for (File file : files) {
            if (file.isFile()) {
                size += file.length();
                continue;
            }
            size += BackupWrapper.calculateDirectorySize(file);
        }
        return size;
    }

    public static File getFirstBackupAfterDate(File directory, long date) {
        File[] files = directory.listFiles();
        File oldestFile = null;
        long currentDate = Long.MAX_VALUE;
        if (files == null || files.length == 0) {
            return null;
        }
        for (File file : files) {
            if (file.lastModified() >= currentDate || file.lastModified() <= date) continue;
            currentDate = file.lastModified();
            oldestFile = file;
        }
        return oldestFile;
    }

    public static int calculateChainCount(File directory) {
        int count = 0;
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            return 0;
        }
        for (File file : files) {
            if (!file.getName().contains("full")) continue;
            ++count;
        }
        return count;
    }

    public static int calculateBackupCount(File directory) {
        File[] files = directory.listFiles();
        if (files == null || files.length == 0) {
            return 0;
        }
        return files.length;
    }

    private static void checkCount(File directory) {
        if (ConfigManager.backupsToKeep.get() <= 0L) {
            return;
        }
        long date = 0L;
        block0: while ((long)BackupWrapper.calculateBackupCount(directory) > ConfigManager.backupsToKeep.get()) {
            File file = BackupWrapper.getFirstBackupAfterDate(directory, date);
            File dependent = BackupWrapper.getDependent(file);
            if (dependent == null) {
                if (file.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(file);
                }
                file.delete();
                continue;
            }
            if ("incremental".equals(ConfigManager.type.get())) {
                if (!ConfigManager.purgeIncrementals.get().booleanValue()) {
                    return;
                }
                if ((long)BackupWrapper.calculateChainCount(directory) <= ConfigManager.incrementalChains.get()) {
                    return;
                }
                if (file.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(file);
                }
                file.delete();
                if (dependent.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(dependent);
                }
                dependent.delete();
                while (true) {
                    if ((dependent = BackupWrapper.getDependent(dependent)) == null) continue block0;
                    if (dependent.isDirectory()) {
                        BackupWrapper.deleteDirectoryContents(dependent);
                    }
                    dependent.delete();
                }
            }
            if (dependent.isDirectory()) {
                BackupWrapper.deleteDirectoryContents(dependent);
            }
            dependent.delete();
        }
        return;
    }

    private static void checkDates(File directory) {
        if (ConfigManager.daysToKeep.get() <= 0L) {
            return;
        }
        long date = 0L;
        long comp = BackupWrapper.mostRecentBackupTime();
        File file;
        long days;
        block0: while ((days = (comp - (date = (file = BackupWrapper.getFirstBackupAfterDate(directory, date)).lastModified())) / 86400000L) > ConfigManager.daysToKeep.get()) {
            File dependent = BackupWrapper.getDependent(file);
            if (dependent == null) {
                if (file.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(file);
                }
                file.delete();
                continue;
            }
            date = dependent.lastModified();
            days = (comp - date) / 86400000L;
            if (days <= ConfigManager.daysToKeep.get()) {
                return;
            }
            if ("incremental".equals(ConfigManager.type.get())) {
                if (!ConfigManager.purgeIncrementals.get().booleanValue()) {
                    return;
                }
                if ((long)BackupWrapper.calculateChainCount(directory) <= ConfigManager.incrementalChains.get()) {
                    return;
                }
                while ((dependent = BackupWrapper.getDependent(dependent)) != null) {
                    date = dependent.lastModified();
                    days = (comp - date) / 86400000L;
                    if (days > ConfigManager.daysToKeep.get()) continue;
                    return;
                }
                dependent = BackupWrapper.getDependent(file);
                if (file.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(file);
                }
                file.delete();
                if (dependent.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(dependent);
                }
                dependent.delete();
                while (true) {
                    if ((dependent = BackupWrapper.getDependent(dependent)) == null) continue block0;
                    if (dependent.isDirectory()) {
                        BackupWrapper.deleteDirectoryContents(dependent);
                    }
                    dependent.delete();
                }
            }
            if (dependent.isDirectory()) {
                BackupWrapper.deleteDirectoryContents(dependent);
            }
            dependent.delete();
        }
        return;
    }

    private static void checkSize(File directory) {
        if (ConfigManager.size.get().floatValue() <= 0.0f) {
            return;
        }
        if ((float)BackupWrapper.calculateDirectorySize(directory) < ConfigManager.size.get().floatValue() * 1.0E9f) {
            return;
        }
        long date = 0L;
        block0: while (!((float)BackupWrapper.calculateDirectorySize(directory) < ConfigManager.size.get().floatValue() * 1.0E9f)) {
            File file = BackupWrapper.getFirstBackupAfterDate(directory, date);
            File dependent = BackupWrapper.getDependent(file);
            if (dependent == null) {
                if (file.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(file);
                }
                file.delete();
                continue;
            }
            if ("incremental".equals(ConfigManager.type.get())) {
                if (!ConfigManager.purgeIncrementals.get().booleanValue()) {
                    return;
                }
                if ((long)BackupWrapper.calculateChainCount(directory) <= ConfigManager.incrementalChains.get()) {
                    return;
                }
                if (file.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(file);
                }
                file.delete();
                if (dependent.isDirectory()) {
                    BackupWrapper.deleteDirectoryContents(dependent);
                }
                dependent.delete();
                while (true) {
                    if ((dependent = BackupWrapper.getDependent(dependent)) == null) continue block0;
                    if (dependent.isDirectory()) {
                        BackupWrapper.deleteDirectoryContents(dependent);
                    }
                    dependent.delete();
                }
            }
            if (dependent.isDirectory()) {
                BackupWrapper.deleteDirectoryContents(dependent);
            }
            dependent.delete();
        }
        return;
    }

    private static void deleteDirectoryContents(File directory) {
        if (!directory.isDirectory()) {
            return;
        }
        for (File file : directory.listFiles()) {
            if (file.isDirectory()) {
                BackupWrapper.deleteDirectoryContents(file);
            }
            file.delete();
        }
    }
}

