/*
 * Decompiled with CFR 0.152.
 */
package computer.heather.advancedbackups.core.config;

import computer.heather.advancedbackups.core.ABCore;
import computer.heather.advancedbackups.core.config.ConfigTypes;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Properties;
import java.util.stream.Collectors;

public class ClientConfigManager {
    private static HashMap<String, ConfigTypes> entries = new HashMap();
    public static final ConfigTypes.BooleanValue showProgress = new ConfigTypes.BooleanValue("config.advancedbackups.showProgress", true, ClientConfigManager::register);
    public static final ConfigTypes.BooleanValue darkMode = new ConfigTypes.BooleanValue("config.advancedbackups.darkToasts", true, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressTextRed = new ConfigTypes.LongValue("config.advancedbackups.colours.progress.red", 82L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressTextGreen = new ConfigTypes.LongValue("config.advancedbackups.colours.progress.green", 255L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressTextBlue = new ConfigTypes.LongValue("config.advancedbackups.colours.progress.blue", 82L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue errorTextRed = new ConfigTypes.LongValue("config.advancedbackups.colours.error.red", 255L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue errorTextGreen = new ConfigTypes.LongValue("config.advancedbackups.colours.error.green", 50L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue errorTextBlue = new ConfigTypes.LongValue("config.advancedbackups.colours.error.blue", 50L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressBarRed = new ConfigTypes.LongValue("config.advancedbackups.colours.bar.red", 88L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressBarGreen = new ConfigTypes.LongValue("config.advancedbackups.colours.bar.green", 242L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressBarBlue = new ConfigTypes.LongValue("config.advancedbackups.colours.bar.blue", 82L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressBackgroundRed = new ConfigTypes.LongValue("config.advancedbackups.colours.background.red", 255L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressBackgroundGreen = new ConfigTypes.LongValue("config.advancedbackups.colours.background.green", 255L, 0L, 255L, ClientConfigManager::register);
    public static final ConfigTypes.LongValue progressBackgroundBlue = new ConfigTypes.LongValue("config.advancedbackups.colours.background.blue", 255L, 0L, 255L, ClientConfigManager::register);

    public static void register(String key, ConfigTypes configType) {
        entries.put(key, configType);
    }

    public static void loadOrCreateConfig() {
        File file;
        File dir = new File("./config");
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if (!(file = new File(dir, "AdvancedBackups-client.properties")).exists()) {
            ClientConfigManager.writeConfig();
        }
        ClientConfigManager.loadConfig();
    }

    private static void writeConfig() {
        ABCore.infoLogger.accept("Preparing to write to client properties file...");
        File file = new File("./config/AdvancedBackups-client.properties");
        try {
            file.createNewFile();
            file.setWritable(true);
            InputStream is = ClientConfigManager.class.getClassLoader().getResourceAsStream("advancedbackups-client-properties.txt");
            String text = new BufferedReader(new InputStreamReader(is, StandardCharsets.UTF_8)).lines().collect(Collectors.joining("\n"));
            for (String key : entries.keySet()) {
                text = text.replace(key, key + "=" + entries.get(key).save());
            }
            FileWriter writer = new FileWriter(file);
            writer.write(text);
            writer.close();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
        }
    }

    private static void loadConfig() {
        Properties props = new Properties();
        File file = new File("./config/AdvancedBackups-client.properties");
        try {
            FileReader reader = new FileReader(file);
            props.load(reader);
            reader.close();
        }
        catch (IOException e) {
            ABCore.logStackTrace(e);
            return;
        }
        ArrayList<String> missingProps = new ArrayList<String>();
        for (String key : entries.keySet()) {
            if (!props.containsKey(key)) {
                missingProps.add(key);
                ABCore.warningLogger.accept("Missing key : " + key);
                continue;
            }
            ConfigTypes.ConfigValidationEnum valid = entries.get(key).validate(props.getProperty(key));
            if (valid != ConfigTypes.ConfigValidationEnum.VALID) {
                missingProps.add(key);
                ABCore.warningLogger.accept(valid.getError() + " : " + key);
                continue;
            }
            entries.get(key).load(props.getProperty(key));
        }
        if (!missingProps.isEmpty()) {
            ABCore.warningLogger.accept("The following properties were missing from the loaded file :");
            for (String string : missingProps) {
                ABCore.warningLogger.accept(string);
            }
            ABCore.warningLogger.accept("Client properties file will be regenerated! Existing config values will be preserved.");
            ClientConfigManager.writeConfig();
        }
    }
}

