/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.config;

import com.illusivesoulworks.spectrelib.config.SpectreConfig;
import com.illusivesoulworks.spectrelib.config.SpectreConfigLoader;
import com.illusivesoulworks.spectrelib.config.SpectreConfigSpec;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.Pair;

public class VeinMiningConfig {
    public static final SpectreConfigSpec SERVER_SPEC;
    public static final SpectreConfigSpec CLIENT_SPEC;
    public static final Server SERVER;
    public static final Client CLIENT;
    private static final String CONFIG_PREFIX = "gui.veinmining.config.";

    public static void setup() {
        String id = "veinmining";
        SpectreConfigLoader.add((SpectreConfig.Type)SpectreConfig.Type.SERVER, (SpectreConfigSpec)SERVER_SPEC, (String)id);
        SpectreConfigLoader.add((SpectreConfig.Type)SpectreConfig.Type.CLIENT, (SpectreConfigSpec)CLIENT_SPEC, (String)id);
    }

    static {
        Pair specPairServer = new SpectreConfigSpec.Builder().configure(Server::new);
        SERVER_SPEC = (SpectreConfigSpec)specPairServer.getRight();
        SERVER = (Server)specPairServer.getLeft();
        Pair specPairClient = new SpectreConfigSpec.Builder().configure(Client::new);
        CLIENT_SPEC = (SpectreConfigSpec)specPairClient.getRight();
        CLIENT = (Client)specPairClient.getLeft();
    }

    public static class Server {
        public final SpectreConfigSpec.DoubleValue requiredDestroySpeed;
        public final SpectreConfigSpec.BooleanValue requireCorrectTool;
        public final SpectreConfigSpec.IntValue maxBlocksBase;
        public final SpectreConfigSpec.IntValue maxBlocksPerLevel;
        public final SpectreConfigSpec.BooleanValue diagonalMining;
        public final SpectreConfigSpec.BooleanValue relocateDrops;
        public final SpectreConfigSpec.BooleanValue preventToolDestruction;
        public final SpectreConfigSpec.BooleanValue addToolDamage;
        public final SpectreConfigSpec.IntValue toolDamageMultiplier;
        public final SpectreConfigSpec.BooleanValue addExhaustion;
        public final SpectreConfigSpec.DoubleValue exhaustionMultiplier;
        public final SpectreConfigSpec.BooleanValue limitedByDurability;
        public final SpectreConfigSpec.BooleanValue limitedByWorld;
        public final SpectreConfigSpec.EnumValue<BlocksType> blocks;
        public final SpectreConfigSpec.TransformableValue<List<? extends String>, Set<String>> blocksList;
        public final SpectreConfigSpec.EnumValue<ListType> blocksListType;

        public Server(SpectreConfigSpec.Builder builder) {
            this.requiredDestroySpeed = builder.comment("The minimum destroy speed the used tool needs on the block to vein mine.").translation("gui.veinmining.config.requiredDestroySpeed").defineInRange("requiredDestroySpeed", 1.0, 0.0, 100.0);
            this.requireCorrectTool = builder.comment("If enabled, vein mining will not activate if the used tool cannot harvest drops from the source block.").translation("gui.veinmining.config.requireCorrectTool").define("requireCorrectTool", false);
            this.maxBlocksBase = builder.comment("The maximum number of blocks to vein mine without the enchantment.").translation("gui.veinmining.config.maxBlocksBase").defineInRange("maxBlocksBase", 0, 0, 1000);
            this.maxBlocksPerLevel = builder.comment("The maximum number of blocks to vein mine per level of the enchantment.").translation("gui.veinmining.config.maxBlocksPerLevel").defineInRange("maxBlocksPerLevel", 50, 1, 1000);
            this.diagonalMining = builder.comment("If enabled, vein mining can mine diagonally.").translation("gui.veinmining.config.diagonalMining").define("diagonalMining", true);
            this.limitedByDurability = builder.comment("If enabled, vein mining will stop when the tool can no longer be used.").translation("gui.veinmining.config.limitedByDurability").define("limitedByDurability", true);
            this.relocateDrops = builder.comment("If enabled, vein mining will move drops from blocks to the source location.").translation("gui.veinmining.config.relocateDrops").define("relocateDrops", true);
            this.preventToolDestruction = builder.comment("If enabled, vein mining will never break tools.").translation("gui.veinmining.config.preventToolDestruction").define("preventToolDestruction", true);
            this.addToolDamage = builder.comment("If enabled, vein mining will damage the tool for each block mined.").translation("gui.veinmining.config.addToolDamage").define("addToolDamage", true);
            this.toolDamageMultiplier = builder.comment("The multiplier to tool damage from blocks that are vein mined.").translation("gui.veinmining.config.toolDamageMultiplier").defineInRange("toolDamageMultiplier", 1, 0, 1000);
            this.addExhaustion = builder.comment("If enabled, vein mining will cause player exhaustion for each block mined.").translation("gui.veinmining.config.addExhaustion").define("addExhaustion", true);
            this.exhaustionMultiplier = builder.comment("The multiplier to player exhaustion from blocks that are vein mined.").translation("gui.veinmining.config.exhaustionMultiplier").defineInRange("exhaustionMultiplier", 1.0, 0.0, 1000.0);
            this.limitedByWorld = builder.comment("If enabled, vein mining will not attempt to mine past the boundary of a world.").translation("gui.veinmining.config.limitedByWorld").define("limitedByWorld", true);
            this.blocks = builder.comment("Determines the vein mineable blocks based on a preset option or a configured list.").translation("gui.veinmining.config.blocks").defineEnum("blocks", (Enum)BlocksType.CONFIG_LIST);
            this.blocksList = builder.comment("The blocks or block tags for vein mining if blocks is set to \"CONFIG_LIST\".").translation("gui.veinmining.config.blocksList").defineList("blocksList", List.of("#c:ores", "#forge:ores", "#minecraft:logs"), s -> s instanceof String, Set::copyOf);
            this.blocksListType = builder.comment("Determines if blocksList contains allowed blocks or denied blocks.").translation("gui.veinmining.config.blocksListType").defineEnum("blocksListType", (Enum)ListType.ALLOW);
        }
    }

    public static class Client {
        public final SpectreConfigSpec.EnumValue<ActivationState> activationState;
        public final SpectreConfigSpec.EnumValue<ActivationState> activationStateWithoutEnchantment;
        public final SpectreConfigSpec.BooleanValue enableEnchantmentWarnings;
        public final SpectreConfigSpec.BooleanValue enableEnchantmentTooltips;
        public final SpectreConfigSpec.BooleanValue enableEnchantmentNotifications;

        public Client(SpectreConfigSpec.Builder builder) {
            this.activationState = builder.comment("If maxBlocksBase from veinmining-server.toml is 0, determines how to activate vein mining.\nIMPORTANT: When using the \"HOLD_KEY_DOWN\" setting, remember to set a keybinding by going to Options > Controls > Key Binds.").translation("gui.veinmining.config.activationState").defineEnum("activationState", (Enum)ActivationState.STANDING);
            this.activationStateWithoutEnchantment = builder.comment("If maxBlocksBase from veinmining-server.toml is greater than 0, determines how to activate vein mining.\nIMPORTANT: When using the \"HOLD_KEY_DOWN\" setting, remember to set a keybinding by going to Options > Controls > Key Binds.").translation("gui.veinmining.config.activationStateWithoutEnchantment").defineEnum("activationStateWithoutEnchantment", (Enum)ActivationState.HOLD_KEY_DOWN);
            this.enableEnchantmentWarnings = builder.comment("If enabled, users will be sent warnings about improper enchantment usage.").translation("gui.veinmining.config.enableEnchantmentWarnings").define("enableEnchantmentWarnings", true);
            this.enableEnchantmentTooltips = builder.comment("If enabled, instructions on how to vein mine will appear in the tooltip of enchanted items.").translation("gui.veinmining.config.enableEnchantmentTooltips").define("enableEnchantmentTooltips", true);
            this.enableEnchantmentNotifications = builder.comment("If enabled, instructions on how to vein mine will appear above the hotbar when switching to enchanted items.").translation("gui.veinmining.config.enableEnchantmentNotifications").define("enableEnchantmentNotifications", false);
        }
    }

    public static enum BlocksType {
        CONFIG_LIST,
        ALL,
        ORES,
        ORES_LOGS,
        ORES_STONE,
        ORES_STONE_LOGS,
        NO_BLOCK_ENTITIES;

    }

    public static enum ActivationState {
        STANDING,
        CROUCHING,
        HOLD_KEY_DOWN;

    }

    public static enum ListType {
        ALLOW,
        DENY;

    }
}

