/*
 * Decompiled with CFR 0.152.
 */
package com.illusivesoulworks.veinmining.common.veinmining;

import com.illusivesoulworks.veinmining.VeinMiningConstants;
import com.illusivesoulworks.veinmining.common.config.VeinMiningConfig;
import com.illusivesoulworks.veinmining.common.platform.Services;
import com.illusivesoulworks.veinmining.common.veinmining.VeinMiningPlayers;
import com.illusivesoulworks.veinmining.common.veinmining.logic.BlockProcessor;
import com.illusivesoulworks.veinmining.common.veinmining.logic.VeinMiningLogic;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.registries.Registries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class VeinMiningEvents {
    public static void tick(Level level) {
        if (!level.isClientSide()) {
            VeinMiningPlayers.validate(level.getGameTime());
        }
    }

    public static void reloadDatapack() {
        BlockProcessor.rebuild();
    }

    public static void blockBreak(ServerPlayer player, BlockPos pos, BlockState state) {
        if (VeinMiningPlayers.canStartVeinMining((Player)player) && !VeinMiningPlayers.isVeinMining((Player)player)) {
            VeinMiningPlayers.startVeinMining((Player)player);
            VeinMiningLogic.veinMine(player, pos, state);
            VeinMiningPlayers.stopVeinMining((Player)player);
        }
    }

    public static void playerLoggedOut(ServerPlayer player) {
        VeinMiningPlayers.deactivateVeinMining((Player)player);
        VeinMiningPlayers.stopVeinMining((Player)player);
    }

    public static void toolEquip(ItemStack to, ItemStack from, EquipmentSlot slot, LivingEntity livingEntity) {
        if (!ItemStack.isSameItem((ItemStack)to, (ItemStack)from) && livingEntity instanceof ServerPlayer) {
            boolean needsEnchantment;
            ServerPlayer player = (ServerPlayer)livingEntity;
            boolean bl = needsEnchantment = (Integer)VeinMiningConfig.SERVER.maxBlocksBase.get() == 0;
            if (needsEnchantment && slot == EquipmentSlot.MAINHAND) {
                int level;
                Holder enchantment = player.registryAccess().lookup(Registries.ENCHANTMENT).map(enchantmentRegistryLookup -> enchantmentRegistryLookup.getOrThrow(VeinMiningConstants.ENCHANTMENT)).orElse(null);
                int n = level = enchantment != null ? EnchantmentHelper.getItemEnchantmentLevel((Holder)enchantment, (ItemStack)to) : 0;
                if (level > 0) {
                    Services.PLATFORM.sendNotifyS2C(player);
                }
            }
        }
    }
}

