/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.client.gui.widgets;

import com.simibubi.create.foundation.gui.widget.SelectionScrollInput;
import de.mrjulsen.crn.client.gui.CreateDynamicWidgets;
import de.mrjulsen.crn.client.gui.widgets.AbstractFlyoutWidget;
import de.mrjulsen.crn.client.gui.widgets.flyouts.FlyoutScrollInput;
import de.mrjulsen.mcdragonlib.client.gui.DLScreen;
import de.mrjulsen.mcdragonlib.client.gui.widgets.DLContextMenu;
import de.mrjulsen.mcdragonlib.client.gui.widgets.IDragonLibWidget;
import de.mrjulsen.mcdragonlib.client.util.Graphics;
import de.mrjulsen.mcdragonlib.client.util.GuiUtils;
import de.mrjulsen.mcdragonlib.core.EAlignment;
import de.mrjulsen.mcdragonlib.data.Cache;
import de.mrjulsen.mcdragonlib.util.DLUtils;
import de.mrjulsen.mcdragonlib.util.TextUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Function;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarrationElementOutput;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;

public class DLCreateSelectionScrollInput
extends SelectionScrollInput
implements IDragonLibWidget {
    private boolean mouseSelected;
    protected boolean renderArrow;
    protected Function<DLCreateSelectionScrollInput, List<Component>> onTooltip;
    protected final Cache<List<Component>> cachedTooltip = new Cache(() -> {
        ArrayList<MutableComponent> tooltips = new ArrayList<MutableComponent>(this.getToolTip());
        tooltips.add(TextUtils.translate((String)"gui.createrailwaysnavigator.common.click_to_search").withStyle(ChatFormatting.DARK_GRAY).withStyle(ChatFormatting.ITALIC));
        DLUtils.doIfNotNull(this.onTooltip, x -> tooltips.addAll((Collection)this.onTooltip.apply(this)));
        return tooltips;
    });
    protected final DLScreen parent;
    boolean renderTooltip = true;

    public DLCreateSelectionScrollInput(DLScreen parent, int x, int y, int width, int height) {
        super(x, y, width, height);
        this.parent = parent;
    }

    public DLCreateSelectionScrollInput setRenderArrow(boolean b) {
        this.renderArrow = b;
        return this;
    }

    public DLCreateSelectionScrollInput onRenderTooltip(Function<DLCreateSelectionScrollInput, List<Component>> action) {
        this.onTooltip = action;
        this.cachedTooltip.clear();
        return this;
    }

    public boolean shouldRenderArrow() {
        return this.renderArrow;
    }

    public Component getText() {
        return (Component)this.formatter.apply(this.state);
    }

    public void onChanged() {
        super.onChanged();
        this.cachedTooltip.clear();
    }

    public List<Component> getOptions() {
        return this.options.stream().map(x -> x).toList();
    }

    public final void renderWidget(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.renderMainLayer(new Graphics(guiGraphics, guiGraphics.pose()), mouseX, mouseY, partialTicks);
    }

    public void renderMainLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        CreateDynamicWidgets.renderTextBox(graphics, this.x(), this.y(), this.width());
        if (this.shouldRenderArrow()) {
            CreateDynamicWidgets.renderTextBoxArrow(graphics, this.x(), this.y());
        }
        GuiUtils.drawString((Graphics)graphics, (Font)Minecraft.getInstance().font, (int)(this.x() + 5), (int)(this.y() + 5), (FormattedText)this.getText(), (int)-1, (EAlignment)EAlignment.LEFT, (boolean)true);
    }

    public void renderFrontLayer(Graphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (!this.isMouseSelected() || !this.renderTooltip) {
            return;
        }
        GuiUtils.renderTooltip((Screen)this.parent, (AbstractWidget)this, (List)((List)this.cachedTooltip.get()), (int)(this.parent.width() / 3), (Graphics)graphics, (int)mouseX, (int)mouseY);
    }

    public void onClick(double mouseX, double mouseY) {
        new FlyoutScrollInput<GuiEventListener>(this.parent, AbstractFlyoutWidget.FlyoutPointer.UP, CreateDynamicWidgets.ColorShade.DARK, w -> {
            this.renderTooltip = false;
            this.parent.addRenderableWidget(w);
        }, w -> {
            this.renderTooltip = true;
            this.parent.removeWidget(w);
        }, this).open(this);
        super.onClick(mouseX, mouseY);
    }

    public void updateWidgetNarration(NarrationElementOutput narrationElementOutput) {
    }

    public void onFocusChangeEvent(boolean focus) {
    }

    public DLContextMenu getContextMenu() {
        return null;
    }

    public void setMenu(DLContextMenu menu) {
    }

    public boolean isMouseSelected() {
        return this.mouseSelected;
    }

    public void setMouseSelected(boolean selected) {
        this.mouseSelected = selected;
    }

    public int x() {
        return this.getX();
    }

    public int y() {
        return this.getY();
    }

    public void set_x(int x) {
        this.setX(x);
    }

    public void set_y(int y) {
        this.setY(y);
    }

    public void set_width(int w) {
        this.width = w;
    }

    public void set_height(int h) {
        this.height = h;
    }

    public void set_visible(boolean b) {
        this.visible = b;
    }

    public boolean visible() {
        return this.visible;
    }

    public void set_active(boolean b) {
        this.active = b;
    }

    public boolean active() {
        return super.isActive();
    }

    public int width() {
        return this.width;
    }

    public int height() {
        return this.height;
    }
}

