/*
 * Decompiled with CFR 0.152.
 */
package de.mrjulsen.crn.data;

import de.mrjulsen.crn.data.StationTag;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;

public record TrainConnection(String trainName, UUID trainId, ResourceLocation trainIconId, int ticks, String scheduleTitle, StationTag.StationInfo stationDetails) {
    private static final String NBT_TRAIN_NAME = "TrainName";
    private static final String NBT_TRAIN_ID = "Id";
    private static final String NBT_TRAIN_ICON = "Icon";
    private static final String NBT_TICKS = "Ticks";
    private static final String NBT_SCHEDULE_TITLE = "Title";

    public CompoundTag toNbt() {
        CompoundTag nbt = new CompoundTag();
        nbt.putString(NBT_TRAIN_NAME, this.trainName);
        nbt.putUUID(NBT_TRAIN_ID, this.trainId);
        nbt.putString(NBT_TRAIN_ICON, this.trainIconId.getPath());
        nbt.putInt(NBT_TICKS, this.ticks);
        nbt.putString(NBT_SCHEDULE_TITLE, this.scheduleTitle);
        this.stationDetails().writeNbt(nbt);
        return nbt;
    }

    public static TrainConnection fromNbt(CompoundTag nbt) {
        return new TrainConnection(nbt.getString(NBT_TRAIN_NAME), nbt.getUUID(NBT_TRAIN_ID), ResourceLocation.parse((String)nbt.getString(NBT_TRAIN_ICON)), nbt.getInt(NBT_TICKS), nbt.getString(NBT_SCHEDULE_TITLE), StationTag.StationInfo.fromNbt(nbt));
    }
}

