/*
 * Decompiled with CFR 0.152.
 */
package org.popcraft.chunky.command;

import java.util.List;
import java.util.Optional;
import org.popcraft.chunky.Chunky;
import org.popcraft.chunky.command.ChunkyCommand;
import org.popcraft.chunky.command.CommandArguments;
import org.popcraft.chunky.platform.Sender;
import org.popcraft.chunky.util.Input;

public class QuietCommand
implements ChunkyCommand {
    private final Chunky chunky;

    public QuietCommand(Chunky chunky) {
        this.chunky = chunky;
    }

    @Override
    public void execute(Sender sender, CommandArguments arguments) {
        Optional newQuiet = arguments.next().flatMap(Input::tryInteger);
        if (newQuiet.isEmpty()) {
            sender.sendMessage("help_quiet", new Object[0]);
            return;
        }
        int quietInterval = Math.max(0, (Integer)newQuiet.get());
        this.chunky.getConfig().setUpdateInterval(quietInterval);
        sender.sendMessagePrefixed("format_quiet", quietInterval);
    }

    @Override
    public List<String> suggestions(CommandArguments arguments) {
        return List.of();
    }
}

