/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.encryption;

import com.aizistral.nochatreports.common.encryption.AESEncryption;
import com.aizistral.nochatreports.common.encryption.Encryptor;
import java.nio.ByteBuffer;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.AlgorithmParameterSpec;
import javax.crypto.AEADBadTagException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.minecraft.util.Tuple;

public abstract class AESEncryptor<T extends AESEncryption>
extends Encryptor<T> {
    private final T encryption;
    private final SecretKey key;
    private final Cipher encryptor;
    private final Cipher decryptor;
    private final boolean useIV;

    protected AESEncryptor(String key, T encryption) throws InvalidKeyException {
        this(new SecretKeySpec(AESEncryptor.decodeBinaryKey(key), "AES"), encryption);
    }

    protected AESEncryptor(SecretKey key, T encryption) throws InvalidKeyException {
        this.encryption = encryption;
        this.useIV = ((AESEncryption)encryption).requiresIV();
        String mode = ((AESEncryption)encryption).getMode();
        String padding = ((AESEncryption)encryption).getPadding();
        try {
            this.key = key;
            Cipher encryptor = Cipher.getInstance(this.key.getAlgorithm() + "/" + mode + "/" + padding);
            if (this.useIV) {
                encryptor.init(1, (Key)this.key, (AlgorithmParameterSpec)this.generateIV().getA());
            } else {
                encryptor.init(1, this.key);
            }
            this.encryptor = encryptor;
            Cipher decryptor = Cipher.getInstance(this.key.getAlgorithm() + "/" + mode + "/" + padding);
            if (this.useIV) {
                decryptor.init(2, (Key)this.key, (AlgorithmParameterSpec)this.generateIV().getA());
            } else {
                decryptor.init(2, this.key);
            }
            this.decryptor = decryptor;
        }
        catch (NoSuchAlgorithmException | NoSuchPaddingException ex) {
            throw new RuntimeException(ex);
        }
        catch (InvalidAlgorithmParameterException ex) {
            throw new InvalidKeyException(ex);
        }
    }

    @Override
    public String encrypt(String message) {
        try {
            if (this.useIV) {
                Tuple<AlgorithmParameterSpec, byte[]> tuple = this.generateIV();
                this.encryptor.init(1, (Key)this.key, (AlgorithmParameterSpec)tuple.getA());
                byte[] encrypted = this.encryptor.doFinal(AESEncryptor.toBytes(message));
                return AESEncryptor.encodeBase64R(ByteBuffer.allocate(encrypted.length + ((byte[])tuple.getB()).length).put((byte[])tuple.getB()).put(encrypted).array());
            }
            return AESEncryptor.encodeBase64R(this.encryptor.doFinal(AESEncryptor.toBytes(message)));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String decrypt(String message) {
        try {
            if (this.useIV) {
                Tuple<AlgorithmParameterSpec, byte[]> tuple = this.splitIV(AESEncryptor.decodeBase64RBytes(message));
                this.decryptor.init(2, (Key)this.key, (AlgorithmParameterSpec)tuple.getA());
                return AESEncryptor.fromBytes(this.decryptor.doFinal((byte[])tuple.getB()));
            }
            return AESEncryptor.fromBytes(this.decryptor.doFinal(AESEncryptor.decodeBase64RBytes(message)));
        }
        catch (AEADBadTagException ex) {
            return "???";
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | BadPaddingException | IllegalBlockSizeException ex) {
            throw new RuntimeException(ex);
        }
    }

    @Override
    public String getKey() {
        return AESEncryptor.encodeBinaryKey(this.key.getEncoded());
    }

    @Override
    public T getAlgorithm() {
        return this.encryption;
    }

    protected abstract Tuple<AlgorithmParameterSpec, byte[]> generateIV() throws UnsupportedOperationException;

    protected abstract Tuple<AlgorithmParameterSpec, byte[]> splitIV(byte[] var1) throws UnsupportedOperationException;
}

