/*
 * Decompiled with CFR 0.152.
 */
package toni.lib.config;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.neoforged.neoforge.common.ModConfigSpec;

public abstract class ConfigBase {
    public ModConfigSpec specification;
    protected int depth;
    protected List<CValue<?, ?>> allValues;
    protected List<ConfigBase> children;

    public void registerAll(ModConfigSpec.Builder builder) {
        if (this.allValues == null || this.allValues.isEmpty()) {
            System.out.println("[" + this.getClass().getName() + "] All values is empty! This config file contains nothing!");
            return;
        }
        for (CValue<?, ?> cValue : this.allValues) {
            cValue.register(builder);
        }
    }

    public void onLoad() {
        if (this.children != null) {
            this.children.forEach(ConfigBase::onLoad);
        }
    }

    public void onReload() {
        if (this.children != null) {
            this.children.forEach(ConfigBase::onReload);
        }
    }

    public abstract String getName();

    protected ConfigString s(String current, String name, String ... comment) {
        return new ConfigString(this, name, current, comment);
    }

    protected ConfigStringList list(List<String> current, String name, String ... comment) {
        return new ConfigStringList(this, name, current, comment);
    }

    protected ConfigStringList list(List<String> current, String name, Predicate<Object> validator, String ... comment) {
        return new ConfigStringList(this, name, current, validator, comment);
    }

    protected ConfigBool b(boolean current, String name, String ... comment) {
        return new ConfigBool(this, name, current, comment);
    }

    protected ConfigFloat f(float current, float min, float max, String name, String ... comment) {
        return new ConfigFloat(this, name, current, min, max, comment);
    }

    protected ConfigFloat f(float current, float min, String name, String ... comment) {
        return this.f(current, min, Float.MAX_VALUE, name, comment);
    }

    protected ConfigInt i(int current, int min, int max, String name, String ... comment) {
        return new ConfigInt(this, name, current, min, max, comment);
    }

    protected ConfigInt i(int current, int min, String name, String ... comment) {
        return this.i(current, min, Integer.MAX_VALUE, name, comment);
    }

    protected ConfigInt i(int current, String name, String ... comment) {
        return this.i(current, Integer.MIN_VALUE, Integer.MAX_VALUE, name, comment);
    }

    protected <T extends Enum<T>> ConfigEnum<T> e(T defaultValue, String name, String ... comment) {
        return new ConfigEnum(this, name, defaultValue, comment);
    }

    protected ConfigGroup group(int depth, String name, String ... comment) {
        return new ConfigGroup(name, depth, comment);
    }

    protected <T extends ConfigBase> T nested(int depth, Supplier<T> constructor, String ... comment) {
        ConfigBase config = (ConfigBase)constructor.get();
        new ConfigGroup(config.getName(), depth, comment);
        new CValue(this, config.getName(), builder -> {
            config.depth = depth;
            config.registerAll((ModConfigSpec.Builder)builder);
            if (config.depth > depth) {
                builder.pop(config.depth - depth);
            }
            return null;
        }, new String[0]);
        if (this.children == null) {
            this.children = new ArrayList<ConfigBase>();
        }
        this.children.add(config);
        return (T)config;
    }

    public class CValue<V, T extends ModConfigSpec.ConfigValue<V>> {
        protected ModConfigSpec.ConfigValue<V> value;
        protected String name;
        private IValueProvider<V, T> provider;

        public CValue(ConfigBase this$0, String name, IValueProvider<V, T> provider, String ... comment) {
            this.name = name;
            this.provider = builder -> {
                this.addComments((ModConfigSpec.Builder)builder, comment);
                return (ModConfigSpec.ConfigValue)provider.apply(builder);
            };
            if (this$0.allValues == null) {
                this$0.allValues = new ArrayList();
            }
            this$0.allValues.add(this);
        }

        public void addComments(ModConfigSpec.Builder builder, String ... comment) {
            if (comment.length > 0) {
                String[] comments = new String[comment.length + 1];
                comments[0] = ".";
                System.arraycopy(comment, 0, comments, 1, comment.length);
                builder.comment(comments);
            } else {
                builder.comment(".");
            }
        }

        public void register(ModConfigSpec.Builder builder) {
            this.value = (ModConfigSpec.ConfigValue)this.provider.apply(builder);
        }

        public V get() {
            return (V)this.value.get();
        }

        public void set(V value) {
            this.value.set(value);
        }

        public String getName() {
            return this.name;
        }
    }

    public class ConfigString
    extends CValue<String, ModConfigSpec.ConfigValue<String>> {
        public ConfigString(ConfigBase this$0, String name, String defaultValue, String ... comment) {
            super(this$0, name, builder -> builder.define(name, (Object)defaultValue), comment);
        }
    }

    public class ConfigStringList
    extends CValue<List<? extends String>, ModConfigSpec.ConfigValue<List<? extends String>>> {
        public ConfigStringList(ConfigBase this$0, String name, List<String> defaultValue, String ... comment) {
            super(this$0, name, builder -> builder.defineList(name, defaultValue, arg -> true), comment);
        }

        public ConfigStringList(ConfigBase this$0, String name, List<String> defaultValue, Predicate<Object> validator, String ... comment) {
            super(this$0, name, builder -> builder.defineList(name, defaultValue, validator), comment);
        }
    }

    public class ConfigBool
    extends CValue<Boolean, ModConfigSpec.BooleanValue> {
        public ConfigBool(ConfigBase this$0, String name, boolean def, String ... comment) {
            super(this$0, name, builder -> builder.define(name, def), comment);
        }
    }

    public class ConfigFloat
    extends CValue<Double, ModConfigSpec.DoubleValue> {
        public ConfigFloat(ConfigBase this$0, String name, float current, float min, float max, String ... comment) {
            super(this$0, name, builder -> builder.defineInRange(name, (double)current, (double)min, (double)max), comment);
        }

        public float getF() {
            return ((Double)this.get()).floatValue();
        }
    }

    public class ConfigInt
    extends CValue<Integer, ModConfigSpec.IntValue> {
        public ConfigInt(ConfigBase this$0, String name, int current, int min, int max, String ... comment) {
            super(this$0, name, builder -> builder.defineInRange(name, current, min, max), comment);
        }
    }

    public class ConfigEnum<T extends Enum<T>>
    extends CValue<T, ModConfigSpec.EnumValue<T>> {
        public ConfigEnum(String name, T defaultValue, String[] comment) {
            super(this$0, name, builder -> builder.defineEnum(name, defaultValue), comment);
        }
    }

    public class ConfigGroup
    extends CValue<Boolean, ModConfigSpec.BooleanValue> {
        private int groupDepth;
        private String[] comment;

        public ConfigGroup(String name, int depth, String ... comment) {
            super(ConfigBase.this, name, builder -> null, comment);
            this.groupDepth = depth;
            this.comment = comment;
        }

        @Override
        public void register(ModConfigSpec.Builder builder) {
            if (ConfigBase.this.depth > this.groupDepth) {
                builder.pop(ConfigBase.this.depth - this.groupDepth);
            }
            ConfigBase.this.depth = this.groupDepth;
            this.addComments(builder, this.comment);
            builder.push(this.getName());
            ++ConfigBase.this.depth;
        }
    }

    @FunctionalInterface
    protected static interface IValueProvider<V, T extends ModConfigSpec.ConfigValue<V>>
    extends Function<ModConfigSpec.Builder, T> {
    }
}

