/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.worldgen.feature.misc;

import biomesoplenty.api.block.BOPBlocks;
import com.mojang.serialization.Codec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.AmethystClusterBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.feature.Feature;
import net.minecraft.world.level.levelgen.feature.FeaturePlaceContext;
import net.minecraft.world.level.levelgen.feature.configurations.NoneFeatureConfiguration;

public class SmallCrystalFeature
extends Feature<NoneFeatureConfiguration> {
    public SmallCrystalFeature(Codec<NoneFeatureConfiguration> deserializer) {
        super(deserializer);
    }

    public boolean place(FeaturePlaceContext<NoneFeatureConfiguration> featurePlaceContext) {
        WorldGenLevel world = featurePlaceContext.level();
        ChunkGenerator chunkGenerator = featurePlaceContext.chunkGenerator();
        RandomSource rand = featurePlaceContext.random();
        BlockPos pos = featurePlaceContext.origin();
        NoneFeatureConfiguration config = (NoneFeatureConfiguration)featurePlaceContext.config();
        int i = 0;
        for (int j = 0; j < 128; ++j) {
            Direction direction = Direction.getRandom((RandomSource)rand);
            BlockState state = (BlockState)(switch (rand.nextInt(6)) {
                case 3 -> BOPBlocks.ROSE_QUARTZ_CLUSTER.defaultBlockState();
                default -> BOPBlocks.LARGE_ROSE_QUARTZ_BUD.defaultBlockState();
                case 1 -> BOPBlocks.MEDIUM_ROSE_QUARTZ_BUD.defaultBlockState();
                case 0 -> BOPBlocks.SMALL_ROSE_QUARTZ_BUD.defaultBlockState();
            }).setValue((Property)AmethystClusterBlock.FACING, (Comparable)direction);
            BlockPos blockpos = pos.offset(rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4), rand.nextInt(4) - rand.nextInt(4));
            Block ground = world.getBlockState(blockpos.relative(direction.getOpposite())).getBlock();
            if (!world.isEmptyBlock(blockpos) || !state.canSurvive((LevelReader)world, blockpos) || ground == Blocks.BEDROCK) continue;
            world.setBlock(blockpos, state, 2);
            ++i;
        }
        return i > 10;
    }
}

