/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.block.events;

import com.furglitch.vendingblock.Config;
import com.furglitch.vendingblock.blockentity.DisplayBlockEntity;
import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.bus.api.EventPriority;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.entity.player.PlayerInteractEvent;

public class BreakEvent {
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public static void onLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        DisplayBlockEntity displayBlockEntity;
        Level level = event.getLevel();
        BlockPos pos = event.getPos();
        Player player = event.getEntity();
        BlockEntity be = level.getBlockEntity(pos);
        if (be instanceof VendorBlockEntity) {
            VendorBlockEntity vendorBlockEntity = (VendorBlockEntity)be;
            if (!BreakEvent.canBreak(player, (Object)vendorBlockEntity)) {
                event.setCanceled(true);
            }
        } else if (be instanceof DisplayBlockEntity && !BreakEvent.canBreak(player, (Object)(displayBlockEntity = (DisplayBlockEntity)be))) {
            event.setCanceled(true);
        }
    }

    private static boolean canBreak(Player player, Object blockEntity) {
        DisplayBlockEntity display;
        VendorBlockEntity vendor;
        Config.Server.BreakLevel breakLevel = (Config.Server.BreakLevel)((Object)Config.Server.BREAK_LEVEL.get());
        if (blockEntity instanceof VendorBlockEntity && (vendor = (VendorBlockEntity)((Object)blockEntity)).isOwner(player)) {
            return true;
        }
        if (blockEntity instanceof DisplayBlockEntity && (display = (DisplayBlockEntity)((Object)blockEntity)).isOwner(player)) {
            return true;
        }
        switch (breakLevel) {
            case SERVER_OWNER: {
                return BreakEvent.isServerOwner(player);
            }
            case ADMIN: {
                return BreakEvent.isAdmin(player) || BreakEvent.isServerOwner(player);
            }
            case GAMEMASTER: {
                return BreakEvent.isGamemaster(player) || BreakEvent.isAdmin(player) || BreakEvent.isServerOwner(player);
            }
            case MODERATOR: {
                return BreakEvent.isModerator(player) || BreakEvent.isGamemaster(player) || BreakEvent.isAdmin(player) || BreakEvent.isServerOwner(player);
            }
            case BLOCK_OWNER_ONLY: {
                return false;
            }
        }
        return false;
    }

    private static boolean isServerOwner(Player player) {
        return player.hasPermissions(4);
    }

    private static boolean isAdmin(Player player) {
        return player.hasPermissions(3);
    }

    private static boolean isGamemaster(Player player) {
        return player.hasPermissions(2);
    }

    private static boolean isModerator(Player player) {
        return player.hasPermissions(1);
    }
}

