/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.blockentity.transaction;

import com.furglitch.vendingblock.Config;
import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import com.furglitch.vendingblock.blockentity.transaction.VendorBlockInventory;
import com.furglitch.vendingblock.gui.chat.Messages;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public class VendorBlockTransaction {
    public static void purchase(Level level, Player buyer, VendorBlockEntity vendor) {
        ItemStack product = vendor.inventory.getStackInSlot(0);
        ItemStack price = vendor.inventory.getStackInSlot(10);
        if (product.isEmpty() && price.isEmpty()) {
            return;
        }
        Player owner = vendor.getOwnerID() != null ? level.getPlayerByUUID(vendor.getOwnerID()) : null;
        String ownerName = vendor.getOwnerUser();
        String playerName = buyer.getName().getString();
        boolean playerHasPayment = VendorBlockInventory.checkInventory(buyer, price);
        boolean playerHasSpace = VendorBlockInventory.checkInventorySpace(buyer, price, product);
        boolean blockHasStock = VendorBlockInventory.checkStock(vendor, product);
        boolean blockHasSpace = VendorBlockInventory.checkStockSpace(vendor, product, price);
        if (playerHasPayment && playerHasSpace && blockHasStock && blockHasSpace && !product.isEmpty() && !price.isEmpty()) {
            VendorBlockTransaction.giveProduct(buyer, vendor, product);
            VendorBlockTransaction.recievePayment(buyer, vendor, price);
            buyer.sendSystemMessage(Messages.playerBought(product.getCount(), product.getHoverName(), ownerName, price.getCount(), price.getHoverName()));
            if (owner != null && ((Boolean)Config.Client.PURCHASE_MESSAGES.get()).booleanValue()) {
                owner.sendSystemMessage(Messages.ownerSold(product.getCount(), product.getHoverName(), playerName, price.getCount(), price.getHoverName()));
            }
        } else if (playerHasSpace && blockHasStock && !product.isEmpty() && price.isEmpty()) {
            VendorBlockTransaction.giveProduct(buyer, vendor, product);
            buyer.sendSystemMessage(Messages.playerGiveaway(product.getCount(), product.getHoverName(), ownerName));
            if (owner != null && ((Boolean)Config.Client.GIVEAWAY_MESSAGES.get()).booleanValue()) {
                owner.sendSystemMessage(Messages.ownerGiveaway(product.getCount(), product.getHoverName(), playerName));
            }
        } else if (playerHasPayment && blockHasSpace && product.isEmpty() && !price.isEmpty()) {
            VendorBlockTransaction.recievePayment(buyer, vendor, price);
            buyer.sendSystemMessage(Messages.playerRequest(price.getCount(), price.getHoverName(), ownerName));
            if (owner != null && ((Boolean)Config.Client.DONATION_MESSAGES.get()).booleanValue()) {
                owner.sendSystemMessage(Messages.ownerRequest(price.getCount(), price.getHoverName(), playerName));
            }
        } else if (!playerHasPayment) {
            buyer.sendSystemMessage(Messages.playerEmpty(price.getHoverName()));
        } else if (!playerHasSpace) {
            buyer.sendSystemMessage(Messages.playerFull());
        } else if (!blockHasStock) {
            buyer.sendSystemMessage(Messages.vendorSold());
            if (owner != null && ((Boolean)Config.Client.OUT_OF_STOCK_MESSAGES.get()).booleanValue()) {
                owner.sendSystemMessage(Messages.ownerSold());
            }
        } else if (!blockHasSpace) {
            buyer.sendSystemMessage(Messages.vendorFull());
            if (owner != null && ((Boolean)Config.Client.FULL_STORAGE_MESSAGES.get()).booleanValue()) {
                owner.sendSystemMessage(Messages.ownerFull());
            }
        }
        vendor.checkErrorState();
    }

    private static void recievePayment(Player buyer, VendorBlockEntity vendor, ItemStack price) {
        int cost = price.getCount();
        for (int i = 0; i < buyer.getInventory().getContainerSize() && cost > 0; ++i) {
            ItemStack slot = buyer.getInventory().getItem(i);
            if (slot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)price)) continue;
            int toRemove = Math.min(slot.getCount(), cost);
            slot.shrink(toRemove);
            cost -= toRemove;
        }
        int transfer = price.getCount() - cost;
        if (vendor.isDiscarding()) {
            transfer = 0;
        } else {
            for (int i = 1; i <= 9 && transfer > 0; ++i) {
                int freeSpace;
                int space;
                ItemStack slot = vendor.inventory.getStackInSlot(i);
                if (slot.isEmpty()) {
                    space = Math.min(transfer, price.getMaxStackSize());
                    ItemStack insert = price.copy();
                    insert.setCount(space);
                    vendor.inventory.setStackInSlot(i, insert);
                    transfer -= space;
                    continue;
                }
                if (!ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)price) || (freeSpace = Math.min(space = slot.getMaxStackSize() - slot.getCount(), transfer)) <= 0) continue;
                slot.grow(freeSpace);
                transfer -= freeSpace;
            }
        }
    }

    private static void giveProduct(Player buyer, VendorBlockEntity vendor, ItemStack product) {
        int stock = product.getCount();
        if (vendor.isInfinite()) {
            stock = 0;
        } else {
            for (int i = 1; i <= 9 && stock > 0; ++i) {
                ItemStack slot = vendor.inventory.getStackInSlot(i);
                if (slot.isEmpty() || !ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)product)) continue;
                int available = slot.getCount();
                int slotStock = Math.min(available, stock);
                slot.shrink(slotStock);
                stock -= slotStock;
            }
        }
        int transfer = product.getCount() - stock;
        for (int i = 0; i < 36 && transfer > 0; ++i) {
            int freeSpace;
            int space;
            ItemStack slot = buyer.getInventory().getItem(i);
            if (slot.isEmpty()) {
                space = Math.min(transfer, product.getMaxStackSize());
                ItemStack insert = product.copy();
                insert.setCount(space);
                buyer.getInventory().setItem(i, insert);
                transfer -= space;
                continue;
            }
            if (!ItemStack.isSameItemSameComponents((ItemStack)slot, (ItemStack)product) || (freeSpace = Math.min(space = slot.getMaxStackSize() - slot.getCount(), transfer)) <= 0) continue;
            slot.grow(freeSpace);
            transfer -= freeSpace;
        }
    }
}

