/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.gui.display;

import com.furglitch.vendingblock.gui.components.FilterSlot;
import com.furglitch.vendingblock.gui.display.DisplayBlockMenu;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.Slot;

public class DisplayBlockScreen
extends AbstractContainerScreen<DisplayBlockMenu> {
    private static final ResourceLocation BACKGROUND = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/display.png");
    private static final ResourceLocation FACADE = ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"textures/gui/container/slot/facade.png");

    public DisplayBlockScreen(DisplayBlockMenu menu, Inventory inv, Component title) {
        super((AbstractContainerMenu)menu, inv, title);
    }

    protected void renderBg(GuiGraphics guiGraphics, float partialTick, int mouseX, int mouseY) {
        RenderSystem.setShader(GameRenderer::getPositionTexShader);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.setShaderTexture((int)0, (ResourceLocation)BACKGROUND);
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        guiGraphics.blit(BACKGROUND, x, y, 0, 0, this.imageWidth, this.imageHeight);
        List<FilterSlot> filterSlots = this.getFilterSlots();
        if (this.isSlotEmpty(1, filterSlots)) {
            guiGraphics.blit(FACADE, x + 98, y + 35, 0.0f, 0.0f, 16, 16, 16, 16);
        }
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.render(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY);
        this.renderFilterSlotTooltips(guiGraphics, mouseX, mouseY);
    }

    public List<FilterSlot> getFilterSlots() {
        ArrayList<FilterSlot> filterSlots = new ArrayList<FilterSlot>();
        for (Slot slot : ((DisplayBlockMenu)this.menu).slots) {
            if (!(slot instanceof FilterSlot)) continue;
            FilterSlot filterSlot = (FilterSlot)slot;
            filterSlots.add(filterSlot);
        }
        return filterSlots;
    }

    private void renderFilterSlotTooltips(GuiGraphics guiGraphics, int mouseX, int mouseY) {
        int x = (this.width - this.imageWidth) / 2;
        int y = (this.height - this.imageHeight) / 2;
        List<FilterSlot> filterSlots = this.getFilterSlots();
        if (this.isMouseOverSlot(mouseX, mouseY, x + 98, y + 35) && this.isSlotEmpty(1, filterSlots)) {
            MutableComponent tooltip = Component.translatable((String)"menu.vendingblock.tooltip.facade");
            guiGraphics.renderTooltip(this.font, (Component)tooltip, mouseX, mouseY);
        }
    }

    private boolean isSlotEmpty(int slotIndex, List<FilterSlot> filterSlots) {
        for (FilterSlot slot : filterSlots) {
            if (slot.getSlotIndex() != slotIndex) continue;
            return !slot.hasItem();
        }
        return true;
    }

    private boolean isMouseOverSlot(int mouseX, int mouseY, int slotX, int slotY) {
        return mouseX >= slotX && mouseX < slotX + 16 && mouseY >= slotY && mouseY < slotY + 16;
    }
}

