/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.integration.emi;

import com.furglitch.vendingblock.gui.components.FilterSlot;
import com.furglitch.vendingblock.gui.trade.VendorBlockScreen;
import dev.emi.emi.api.EmiDragDropHandler;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.runtime.EmiDrawContext;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.world.item.ItemStack;

public class GhostHandlerBlock
implements EmiDragDropHandler<VendorBlockScreen> {
    public boolean dropStack(VendorBlockScreen screen, EmiIngredient stack, int x, int y) {
        if (!(stack instanceof EmiStack)) {
            return false;
        }
        EmiStack emiStack = (EmiStack)stack;
        ItemStack itemStack = emiStack.getItemStack();
        if (itemStack.isEmpty()) {
            return false;
        }
        for (FilterSlot slot : screen.getFilterSlots().stream().filter(s -> s.getSlotIndex() != 0).toList()) {
            int slotX = screen.getGuiLeft() + slot.x;
            int slotY = screen.getGuiTop() + slot.y;
            if (x < slotX || x >= slotX + 16 || y < slotY || y >= slotY + 16) continue;
            slot.set(itemStack);
            return true;
        }
        return false;
    }

    public void render(VendorBlockScreen screen, EmiIngredient dragged, GuiGraphics guiGraphics, int mouseX, int mouseY, float delta) {
        if (!(dragged instanceof EmiStack)) {
            return;
        }
        EmiStack emiStack = (EmiStack)dragged;
        ItemStack itemStack = emiStack.getItemStack();
        if (itemStack.isEmpty()) {
            return;
        }
        EmiDrawContext context = EmiDrawContext.wrap((GuiGraphics)guiGraphics);
        for (FilterSlot slot : screen.getFilterSlots().stream().filter(s -> s.getSlotIndex() != 0).toList()) {
            int slotX = screen.getGuiLeft() + slot.x;
            int slotY = screen.getGuiTop() + slot.y;
            context.fill(slotX, slotY, 16, 16, -2013200640);
        }
    }
}

