/*
 * Decompiled with CFR 0.152.
 */
package com.furglitch.vendingblock.integration.jade;

import com.furglitch.vendingblock.blockentity.VendorBlockEntity;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IServerDataProvider;

public enum VendorBlockDataProvider implements IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        BlockEntity blockEntity = accessor.getBlockEntity();
        if (blockEntity instanceof VendorBlockEntity) {
            ItemStack price;
            ItemStack product;
            VendorBlockEntity entity = (VendorBlockEntity)blockEntity;
            String ownerUser = entity.getOwnerUser();
            if (ownerUser != null) {
                tag.putString("owner", ownerUser);
            }
            if (!(product = entity.inventory.getStackInSlot(0)).isEmpty()) {
                tag.putString("productName", product.getHoverName().getString());
                tag.putInt("productCount", product.getCount());
            }
            if (!(price = entity.inventory.getStackInSlot(10)).isEmpty()) {
                tag.putString("priceName", price.getHoverName().getString());
                tag.putInt("priceCount", price.getCount());
            }
            tag.putBoolean("hasError", entity.hasError);
            tag.putInt("errorCode", entity.errorCode);
        }
    }

    public ResourceLocation getUid() {
        return ResourceLocation.fromNamespaceAndPath((String)"vendingblock", (String)"vendor_data");
    }
}

