/*
 * Decompiled with CFR 0.152.
 */
package fr.samlegamer.mcwbiomesoplenty;

import fr.samlegamer.addonslib.Finder;
import fr.samlegamer.addonslib.Registration;
import fr.samlegamer.addonslib.bridges.Bridges;
import fr.samlegamer.addonslib.client.APIRenderTypes;
import fr.samlegamer.addonslib.data.ModType;
import fr.samlegamer.addonslib.door.Doors;
import fr.samlegamer.addonslib.fences.Fences;
import fr.samlegamer.addonslib.furnitures.AddFurnituresStorage;
import fr.samlegamer.addonslib.furnitures.Furnitures;
import fr.samlegamer.addonslib.generation.loot_tables.McwLootTables;
import fr.samlegamer.addonslib.generation.tags.McwBlockTags;
import fr.samlegamer.addonslib.generation.tags.McwItemTags;
import fr.samlegamer.addonslib.mapping.MappingMissing;
import fr.samlegamer.addonslib.path.Paths;
import fr.samlegamer.addonslib.roofs.Roofs;
import fr.samlegamer.addonslib.stairs.Stairs;
import fr.samlegamer.addonslib.tab.APICreativeTab;
import fr.samlegamer.addonslib.tab.NewIconRandom;
import fr.samlegamer.addonslib.trapdoor.Trapdoors;
import fr.samlegamer.addonslib.util.McwMod;
import fr.samlegamer.addonslib.windows.Windows;
import fr.samlegamer.mcwbiomesoplenty.Recipes;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.material.MapColor;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLClientSetupEvent;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.common.data.ExistingFileHelper;
import net.neoforged.neoforge.data.event.GatherDataEvent;
import net.neoforged.neoforge.event.BlockEntityTypeAddBlocksEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="mcwbiomesoplenty")
public class McwBOP
extends McwMod {
    public static final String MODID = "mcwbiomesoplenty";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final List<String> WOOD = List.of("dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "maple", "pine");
    public static final List<String> LEAVES = List.of("dead", "fir", "hellbark", "jacaranda", "magic", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "pine", "orange_maple", "red_maple", "yellow_maple", "cypress", "snowblossom", "flowering_oak", "rainbow_birch", "origin");
    protected static final DeferredRegister.Blocks block = Registration.blocks((String)"mcwbiomesoplenty");
    protected static final DeferredRegister.Items item = Registration.items((String)"mcwbiomesoplenty");
    protected static final DeferredRegister<CreativeModeTab> ct = Registration.creativeModeTab((String)"mcwbiomesoplenty");
    public static final DeferredHolder<CreativeModeTab, CreativeModeTab> MCWBOP_TAB = ct.register("tab", () -> CreativeModeTab.builder().title((Component)Component.translatable((String)"mcwbiomesoplenty.tab")).icon(McwBOP::getIcon).build());

    public McwBOP(IEventBus bus) {
        super(bus);
        LOGGER.info("Macaw's Biomes O' Plenty Loading...");
        Registration.init((IEventBus)bus, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, ct);
        MappingMissing.Bridges bridges = new MappingMissing.Bridges("macawsbridgesbop", MODID, WOOD);
        MappingMissing.Furnitures furnitures = new MappingMissing.Furnitures("mcwfurnituresbop", MODID, WOOD);
        MappingMissing.Fences fences = new MappingMissing.Fences("mcwfencesbop", MODID, WOOD);
        MappingMissing.Roofs roofs = new MappingMissing.Roofs("macawsroofsbop", MODID, WOOD);
        LOGGER.info("Start convert blocks");
        fences.leavesAdding(LEAVES);
        bridges.missingnoWoodBlock(block);
        furnitures.missingnoWoodBlock(block);
        fences.missingnoWoodBlock(block);
        roofs.missingnoWoodBlock(block);
        LOGGER.info("Finish convert blocks");
        LOGGER.info("Start convert items");
        fences.leavesAdding(LEAVES);
        bridges.missingnoWoodItem(item);
        furnitures.missingnoWoodItem(item);
        fences.missingnoWoodItem(item);
        roofs.missingnoWoodItem(item);
        LOGGER.info("Finish convert items");
        BlockBehaviour.Properties prop_crimson = BlockBehaviour.Properties.of().mapColor(MapColor.CRIMSON_STEM).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.NETHER_WOOD);
        BlockBehaviour.Properties prop_cherry = BlockBehaviour.Properties.of().mapColor(MapColor.TERRACOTTA_WHITE).instrument(NoteBlockInstrument.BASS).strength(2.0f, 3.0f).sound(SoundType.CHERRY_WOOD).ignitedByLava();
        List<String> woodClassic = List.of("dead", "fir", "mahogany", "palm", "redwood", "willow", "pine");
        List<String> woodCrimson = List.of("hellbark", "umbran", "empyreal");
        List<String> woodCherry = List.of("magic", "jacaranda", "maple");
        List<String> leaveClassic = List.of("dead", "fir", "hellbark", "mahogany", "palm", "redwood", "umbran", "willow", "empyreal", "pine", "cypress", "flowering_oak", "rainbow_birch", "origin");
        List<String> leaveCherry = List.of("snowblossom", "orange_maple", "red_maple", "yellow_maple", "jacaranda", "magic");
        Bridges.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Fences.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Fences.setRegistrationHedges(leaveClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Furnitures.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Roofs.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Trapdoors.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Paths.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Doors.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Windows.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Stairs.setRegistrationWood(woodClassic, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item);
        Bridges.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Fences.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Furnitures.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Roofs.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Trapdoors.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_TRAPDOOR));
        Paths.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Doors.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_DOOR), (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CRIMSON_DOOR));
        Windows.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Stairs.setRegistrationWoodModLoaded(woodCrimson, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_crimson);
        Bridges.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        Fences.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        Fences.setRegistrationHedgesModLoaded(leaveCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.of().mapColor(MapColor.COLOR_PINK).strength(0.2f).randomTicks().sound(SoundType.CHERRY_LEAVES).noOcclusion());
        Furnitures.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        Roofs.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        Trapdoors.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_TRAPDOOR));
        Paths.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        Doors.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_DOOR), (BlockBehaviour.Properties)BlockBehaviour.Properties.ofFullCopy((BlockBehaviour)Blocks.CHERRY_DOOR));
        Windows.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        Stairs.setRegistrationWoodModLoaded(woodCherry, (DeferredRegister.Blocks)block, (DeferredRegister.Items)item, (BlockBehaviour.Properties)prop_cherry);
        bus.addListener(this::addFurnitures);
        bus.addListener(this::clientSetup);
        bus.addListener(this::commonSetup);
        bus.addListener(this::dataSetup);
        bus.addListener(this::tabSetup);
        LOGGER.info("Macaw's Biomes O' Plenty Is Charged !");
    }

    private void addFurnitures(BlockEntityTypeAddBlocksEvent event) {
        AddFurnituresStorage.addCompatibleBlocksToFurnitureStorage((BlockEntityTypeAddBlocksEvent)event, (String)MODID, WOOD);
    }

    public void clientSetup(FMLClientSetupEvent event) {
        APIRenderTypes.initAllWood((FMLClientSetupEvent)event, (String)MODID, WOOD, (ModType[])new ModType[]{ModType.ROOFS, ModType.FENCES, ModType.BRIDGES, ModType.FURNITURES, ModType.WINDOWS, ModType.DOORS, ModType.TRAPDOORS, ModType.PATHS, ModType.STAIRS});
        APIRenderTypes.initAllLeave((FMLClientSetupEvent)event, (String)MODID, LEAVES);
    }

    public void commonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            McwLootTables.addBlockAllWood((String)MODID, WOOD);
            McwLootTables.addBlockHedges((String)MODID, LEAVES);
        });
    }

    public void dataSetup(GatherDataEvent gatherDataEvent) {
        DataGenerator generator = gatherDataEvent.getGenerator();
        PackOutput output = generator.getPackOutput();
        CompletableFuture registries = gatherDataEvent.getLookupProvider();
        ExistingFileHelper existingFileHelper = gatherDataEvent.getExistingFileHelper();
        McwBlockTags mcwBlockTags = new McwBlockTags(this, output, registries, MODID, existingFileHelper){

            protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HolderLookup.Provider provider) {
                this.addAllMcwTags(McwBOP.MODID, WOOD, LEAVES);
            }
        };
        generator.addProvider(true, (DataProvider)new Recipes(output, registries));
        generator.addProvider(true, (DataProvider)mcwBlockTags);
        generator.addProvider(true, (DataProvider)new McwItemTags(this, output, registries, mcwBlockTags.contentsGetter(), MODID, existingFileHelper){

            protected void addTags(// Could not load outer class - annotation placement on inner may be incorrect
             @NotNull HolderLookup.Provider provider) {
                this.addAllMcwTags(McwBOP.MODID, WOOD, LEAVES);
            }
        });
    }

    public void tabSetup(BuildCreativeModeTabContentsEvent event) {
        APICreativeTab.initAllWood((BuildCreativeModeTabContentsEvent)event, (String)MODID, WOOD, (CreativeModeTab)((CreativeModeTab)MCWBOP_TAB.get()), (ModType[])new ModType[]{ModType.ROOFS, ModType.FENCES, ModType.BRIDGES, ModType.FURNITURES, ModType.WINDOWS, ModType.DOORS, ModType.TRAPDOORS, ModType.PATHS, ModType.STAIRS});
        APICreativeTab.initAllLeave((BuildCreativeModeTabContentsEvent)event, (String)MODID, LEAVES, (CreativeModeTab)((CreativeModeTab)MCWBOP_TAB.get()));
    }

    private static ItemStack getIcon() {
        NewIconRandom.NewProperties woodProperties = new NewIconRandom.NewProperties(Finder.findBlock((String)MODID, (String)"redwood_roof"), Finder.findBlock((String)MODID, (String)"redwood_picket_fence"), Finder.findBlock((String)MODID, (String)"redwood_wardrobe"), Finder.findBlock((String)MODID, (String)"redwood_log_bridge_middle"), Finder.findBlock((String)MODID, (String)"redwood_window"), Finder.findBlock((String)MODID, (String)"redwood_japanese_door"), Finder.findBlock((String)MODID, (String)"redwood_glass_trapdoor"), Finder.findBlock((String)MODID, (String)"redwood_planks_path"), Finder.findBlock((String)MODID, (String)"redwood_loft_stairs"));
        woodProperties.addType(NewIconRandom.BlockType.ROOFS).addType(NewIconRandom.BlockType.FENCES).addType(NewIconRandom.BlockType.FURNITURES).addType(NewIconRandom.BlockType.BRIDGES).addType(NewIconRandom.BlockType.WINDOWS).addType(NewIconRandom.BlockType.DOORS).addType(NewIconRandom.BlockType.TRAPDOORS).addType(NewIconRandom.BlockType.PATHS).addType(NewIconRandom.BlockType.STAIRS);
        return new ItemStack((ItemLike)woodProperties.buildIcon(new NewIconRandom.BlockType[]{NewIconRandom.BlockType.ROOFS, NewIconRandom.BlockType.FENCES, NewIconRandom.BlockType.FURNITURES, NewIconRandom.BlockType.BRIDGES, NewIconRandom.BlockType.WINDOWS, NewIconRandom.BlockType.DOORS, NewIconRandom.BlockType.TRAPDOORS, NewIconRandom.BlockType.PATHS, NewIconRandom.BlockType.STAIRS}));
    }
}

