/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.item;

import net.conczin.immersive_paintings.entity.ImmersivePaintingEntity;
import net.conczin.immersive_paintings.registration.Entities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;

public class ImmersivePaintingItem
extends Item {
    public ImmersivePaintingItem() {
        super(new Item.Properties());
    }

    protected boolean mayUseItemAt(Player player, Direction side, ItemStack stack, BlockPos pos) {
        return player.mayUseItemAt(pos, side, stack);
    }

    protected EntityType<? extends ImmersivePaintingEntity> getEntityType() {
        return Entities.PAINTING;
    }

    public InteractionResult useOn(UseOnContext context) {
        ImmersivePaintingEntity entity;
        BlockPos blockPos = context.getClickedPos();
        Direction direction = context.getClickedFace();
        BlockPos attachmentPosition = blockPos.relative(direction);
        Player player = context.getPlayer();
        ItemStack itemStack = context.getItemInHand();
        if (player == null || !this.mayUseItemAt(player, direction, itemStack, attachmentPosition)) {
            return InteractionResult.FAIL;
        }
        Level level = context.getLevel();
        int rotation = 0;
        if (direction.getAxis().isVertical()) {
            rotation = Math.floorMod((int)Math.floor((double)(player.getYRot() / 90.0f) + 2.5) * 90, 360);
        }
        if ((entity = (ImmersivePaintingEntity)this.getEntityType().create(level)) == null) {
            return InteractionResult.FAIL;
        }
        entity.setPos(attachmentPosition);
        entity.setDirection(direction, rotation);
        if (entity.survives()) {
            if (!level.isClientSide) {
                entity.playPlacementSound();
                level.gameEvent((Entity)player, (Holder)GameEvent.ENTITY_PLACE, entity.position());
                level.addFreshEntity((Entity)entity);
            }
            itemStack.shrink(1);
            return InteractionResult.sidedSuccess((boolean)level.isClientSide);
        }
        return InteractionResult.CONSUME;
    }
}

