/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.neoforge;

import java.util.function.Consumer;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.registration.Entities;
import net.conczin.immersive_paintings.registration.Items;
import net.conczin.immersive_paintings.registration.Network;
import net.conczin.immersive_paintings.registration.RegisterHelper;
import net.conczin.immersive_paintings.util.PaintingArgumentType;
import net.minecraft.commands.synchronization.ArgumentTypeInfos;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.server.level.ServerPlayer;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.common.Mod;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.PacketDistributor;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NeoForgeRegistries;
import net.neoforged.neoforge.registries.RegisterEvent;

@Mod(value="immersive_paintings")
@EventBusSubscriber(modid="immersive_paintings", bus=EventBusSubscriber.Bus.MOD)
public final class CommonNeoForge {
    @SubscribeEvent
    public static void setup(FMLCommonSetupEvent event) {
        Main.init();
    }

    private static <T> void registerHelper(RegisterEvent event, Registry<T> register, Consumer<RegisterHelper<T>> consumer) {
        event.register(register.key(), registry -> consumer.accept((arg_0, arg_1) -> ((RegisterEvent.RegisterHelper)registry).register(arg_0, arg_1)));
    }

    @SubscribeEvent
    public static void register(RegisterEvent event) {
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ITEM, Items::registerItems);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.CREATIVE_MODE_TAB, Items::registerCreativeTabs);
        CommonNeoForge.registerHelper(event, BuiltInRegistries.ENTITY_TYPE, Entities::registerEntities);
        CommonNeoForge.registerHelper(event, NeoForgeRegistries.ENTITY_DATA_SERIALIZERS, Entities::registerEntitySerializers);
        ArgumentTypeInfos.registerByClass(PaintingArgumentType.class, PaintingArgumentType.INFO);
        event.register(BuiltInRegistries.COMMAND_ARGUMENT_TYPE.key(), Main.locate("painting_argument"), () -> PaintingArgumentType.INFO);
    }

    @SubscribeEvent
    public static void registerNetwork(RegisterPayloadHandlersEvent event) {
        Network.register(CommonNeoForge.usingRegistrar(event.registrar("1")));
        NetworkHandler.registerSender((x$0, x$1) -> PacketDistributor.sendToPlayer((ServerPlayer)x$0, (CustomPacketPayload)x$1, (CustomPacketPayload[])new CustomPacketPayload[0]));
    }

    public static Network.Registrar usingRegistrar(final PayloadRegistrar registrar) {
        return new Network.Registrar(){

            @Override
            public <T extends ImmersivePayload> void register(CustomPacketPayload.Type<T> type, StreamCodec<FriendlyByteBuf, T> codec, boolean isServer) {
                if (isServer) {
                    registrar.playToServer(type, codec, (payload, ctx) -> payload.handle(ctx.player(), arg_0 -> ((IPayloadContext)ctx).enqueueWork(arg_0)));
                } else {
                    registrar.playToClient(type, codec, (payload, ctx) -> payload.handle(ctx.player(), arg_0 -> ((IPayloadContext)ctx).enqueueWork(arg_0)));
                }
            }
        };
    }
}

