/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.s2c;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.entity.player.Player;

public record OpenGuiPayload(GuiType guiType, int entityId, int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<OpenGuiPayload> TYPE = new CustomPacketPayload.Type(Main.locate("open_gui"));
    public static final StreamCodec<FriendlyByteBuf, OpenGuiPayload> STREAM_CODEC = StreamCodec.composite(GuiType.STREAM_CODEC, OpenGuiPayload::guiType, (StreamCodec)ByteBufCodecs.INT, OpenGuiPayload::entityId, (StreamCodec)ByteBufCodecs.INT, OpenGuiPayload::minResolution, (StreamCodec)ByteBufCodecs.INT, OpenGuiPayload::maxResolution, (StreamCodec)ByteBufCodecs.BOOL, OpenGuiPayload::showOtherPlayersPaintings, (StreamCodec)ByteBufCodecs.INT, OpenGuiPayload::uploadPermissionLevel, OpenGuiPayload::new);

    @Override
    public void handle(Player player, ImmersivePayload.Runner runnable) {
        GuiType type = this.guiType();
        int entityId = this.entityId();
        int minResolution = this.minResolution();
        int maxResolution = this.maxResolution();
        boolean showOtherPlayersPaintings = this.showOtherPlayersPaintings();
        int uploadPermissionLevel = this.uploadPermissionLevel();
        runnable.run(() -> {
            if (type == GuiType.EDITOR) {
                ScreenProxy.load(entityId, minResolution, maxResolution, showOtherPlayersPaintings, uploadPermissionLevel);
            }
        });
    }

    public CustomPacketPayload.Type<OpenGuiPayload> type() {
        return TYPE;
    }

    public static enum GuiType implements StringRepresentable
    {
        EDITOR;

        public static final Codec<GuiType> CODEC;
        public static final StreamCodec<ByteBuf, GuiType> STREAM_CODEC;

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(GuiType::values);
            STREAM_CODEC = ByteBufCodecs.fromCodec(CODEC);
        }
    }

    private static class ScreenProxy {
        private ScreenProxy() {
        }

        public static void load(int entityId, int minResolution, int maxResolution, boolean showOtherPlayersPaintings, int uploadPermissionLevel) {
            Minecraft.getInstance().setScreen((Screen)new ImmersivePaintingScreen(entityId, minResolution, maxResolution, showOtherPlayersPaintings, uploadPermissionLevel));
        }
    }
}

