/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.s2c;

import java.util.Map;
import java.util.Optional;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.network.NetworkHandler;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.network.payload.c2s.PaintingEditPayload;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.codec.StreamDecoder;
import net.minecraft.network.codec.StreamEncoder;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PaintingRegisterErrorPayload(Optional<ResourceLocation> identifier, String error) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<PaintingRegisterErrorPayload> TYPE = new CustomPacketPayload.Type(Main.locate("painting_register_response"));
    public static final StreamCodec<FriendlyByteBuf, PaintingRegisterErrorPayload> STREAM_CODEC = StreamCodec.of((buf, msg) -> {
        buf.writeOptional(msg.identifier(), (StreamEncoder)ResourceLocation.STREAM_CODEC);
        buf.writeUtf(msg.error());
    }, buf -> {
        Optional identifier = buf.readOptional((StreamDecoder)ResourceLocation.STREAM_CODEC);
        String err = buf.readUtf();
        return new PaintingRegisterErrorPayload(identifier, err);
    });

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        Optional<ResourceLocation> id = this.identifier();
        String err = this.error();
        runner.run(() -> {
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (patt0$temp instanceof ImmersivePaintingScreen) {
                ImmersivePaintingScreen screen = (ImmersivePaintingScreen)patt0$temp;
                if (err.isEmpty()) {
                    if (screen.entity != null && id.isPresent()) {
                        NetworkHandler.Client.sendToServer(new PaintingEditPayload(screen.entity.getId(), Map.of(PaintingEditPayload.Option.MOTIVE, ((ResourceLocation)id.get()).toString(), PaintingEditPayload.Option.FRAME, screen.entity.getFrame().toString(), PaintingEditPayload.Option.MATERIAL, screen.entity.getMaterial().toString())));
                        if (screen.entity.isGraffiti()) {
                            Minecraft.getInstance().setScreen(null);
                        } else {
                            screen.setPage(ImmersivePaintingScreen.Page.FRAME);
                        }
                    }
                } else {
                    screen.setPage(ImmersivePaintingScreen.Page.CREATE);
                    screen.setError((Component)Component.translatable((String)("immersive_paintings.error." + err)));
                }
            }
        });
    }

    public CustomPacketPayload.Type<PaintingRegisterErrorPayload> type() {
        return TYPE;
    }
}

