/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.network.payload.s2c;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import net.conczin.immersive_paintings.ClientPaintingManager;
import net.conczin.immersive_paintings.Main;
import net.conczin.immersive_paintings.Painting;
import net.conczin.immersive_paintings.client.gui.ImmersivePaintingScreen;
import net.conczin.immersive_paintings.network.payload.ImmersivePayload;
import net.conczin.immersive_paintings.registration.Configs;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;

public record PaintingSyncPayload(Map<ResourceLocation, Optional<Painting>> paintings, boolean clear) implements ImmersivePayload
{
    public static final CustomPacketPayload.Type<PaintingSyncPayload> TYPE = new CustomPacketPayload.Type(Main.locate("painting_list"));
    public static final StreamCodec<FriendlyByteBuf, PaintingSyncPayload> STREAM_CODEC = StreamCodec.composite((StreamCodec)ByteBufCodecs.map(HashMap::new, (StreamCodec)ResourceLocation.STREAM_CODEC, (StreamCodec)ByteBufCodecs.optional(Painting.STREAM_CODEC)), PaintingSyncPayload::paintings, (StreamCodec)ByteBufCodecs.BOOL, PaintingSyncPayload::clear, PaintingSyncPayload::new);

    public PaintingSyncPayload(ResourceLocation identifier, Painting painting) {
        this(Map.of(identifier, Optional.ofNullable(painting)), false);
    }

    public static List<PaintingSyncPayload> splitPaintings(Map<ResourceLocation, Optional<Painting>> paintings, boolean clearFirst) {
        int currentSize;
        ArrayList<PaintingSyncPayload> paintingsList = new ArrayList<PaintingSyncPayload>();
        int interval = Configs.COMMON.packetSplitInterval;
        Map<ResourceLocation, Optional<Painting>> optionalPaintings = paintings.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        if (paintings.size() < interval) {
            Main.LOGGER.debug("Found {} paintings, < {}", (Object)paintings.size(), (Object)interval);
            paintingsList.add(new PaintingSyncPayload(optionalPaintings, clearFirst));
            return paintingsList;
        }
        Main.LOGGER.debug("Found {} paintings, >= {}, splitting into {} groups", (Object)paintings.size(), (Object)interval, (Object)(paintings.size() / interval + Math.min(paintings.size() % interval, 1)));
        int totalSize = paintings.size();
        for (int processed = 0; processed < totalSize; processed += currentSize) {
            currentSize = Math.min(totalSize - processed, interval);
            Map<ResourceLocation, Optional<Painting>> p = optionalPaintings.entrySet().stream().skip(processed).limit(currentSize).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            paintingsList.add(new PaintingSyncPayload(p, processed == 0 && clearFirst));
        }
        return paintingsList;
    }

    @Override
    public void handle(Player player, ImmersivePayload.Runner runner) {
        Map<ResourceLocation, Optional<Painting>> paintings = this.paintings();
        boolean cleared = this.clear();
        runner.run(() -> {
            if (cleared) {
                ClientPaintingManager.getPaintings().clear();
            }
            paintings.forEach((id, painting) -> {
                if (painting.isEmpty()) {
                    ClientPaintingManager.deregisterPainting(id);
                } else {
                    ClientPaintingManager.registerPainting(id, (Painting)painting.get());
                }
            });
            Screen patt0$temp = Minecraft.getInstance().screen;
            if (patt0$temp instanceof ImmersivePaintingScreen) {
                ImmersivePaintingScreen screen = (ImmersivePaintingScreen)patt0$temp;
                screen.refreshPage();
            }
        });
    }

    public CustomPacketPayload.Type<PaintingSyncPayload> type() {
        return TYPE;
    }
}

