/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.immersive_paintings.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Stream;
import net.conczin.immersive_paintings.Main;

public abstract class Cache<K, V> {
    public static final Path CACHE_PATH = Path.of("immersive_paintings_cache", new String[0]);
    private final Map<K, V> cache;

    public Cache() {
        this(200);
    }

    public Cache(final int maxEntries) {
        this.cache = Collections.synchronizedMap(new LinkedHashMap<K, V>(maxEntries + 1, 0.75f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
                return this.size() > maxEntries;
            }
        });
    }

    public abstract String getCachePath(K var1);

    public abstract V decode(byte[] var1) throws IOException;

    public abstract byte[] encode(V var1);

    private File getFile(K key) {
        Path path = CACHE_PATH.resolve(this.getCachePath(key));
        return Files.exists(path, new LinkOption[0]) ? path.toFile() : null;
    }

    public boolean exists(K key) {
        return this.getFile(key) != null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<V> get(K key) {
        if (this.cache.containsKey(key)) {
            return Optional.of(this.cache.get(key));
        }
        File file = this.getFile(key);
        if (file == null) {
            return Optional.empty();
        }
        try (FileInputStream stream = new FileInputStream(file);){
            V data = this.decode(stream.readAllBytes());
            if (data == null) {
                Optional optional = Optional.empty();
                return optional;
            }
            this.cache.put(key, data);
            Optional<V> optional = Optional.of(data);
            return optional;
        }
        catch (IOException e) {
            Main.LOGGER.error("failed getting cached file {}", (Object)file, (Object)e);
            return Optional.empty();
        }
    }

    public void set(K key, V value) {
        Path path = CACHE_PATH.resolve(this.getCachePath(key));
        if (!Files.exists(path.getParent(), new LinkOption[0])) {
            try {
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
            }
            catch (IOException e) {
                Main.LOGGER.error("failed creating directories for {}", (Object)path.getParent(), (Object)e);
                return;
            }
        }
        try (FileOutputStream outputStream = new FileOutputStream(path.toFile());){
            byte[] v = this.encode(value);
            if (v != null) {
                outputStream.write(v);
                this.cache.put(key, value);
            }
        }
        catch (IOException e) {
            Main.LOGGER.error("failed writing cached file {}", (Object)path, (Object)e);
        }
    }

    public boolean delete(K key) {
        this.cache.remove(key);
        File file = this.getFile(key);
        if (file == null) {
            return false;
        }
        boolean deleted = file.delete();
        Path parent = file.toPath().getParent();
        try (Stream<Path> entries = Files.list(parent);){
            if (entries.findAny().isEmpty()) {
                Files.delete(parent);
            }
        }
        catch (IOException e) {
            Main.LOGGER.error("failed deleting cache directory {}", (Object)parent, (Object)e);
        }
        return deleted;
    }
}

