/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.api;

import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeType;
import org.apache.commons.lang3.ArrayUtils;

public interface RecipeFilter {
    public static final RecipeFilter ALWAYS_APPLY = (recipe, registryAccess) -> true;

    public boolean shouldApply(RecipeHolder<?> var1, HolderLookup.Provider var2);

    public static RecipeFilter acceptsIngredient(ItemStack item) {
        return (recipe, registryAccess) -> {
            for (Ingredient ingredient : recipe.value().getIngredients()) {
                if (!ingredient.test(item)) continue;
                return true;
            }
            return false;
        };
    }

    public static RecipeFilter resultItemIs(Item item) {
        return (recipe, registryAccess) -> recipe.value().getResultItem(registryAccess).is(item);
    }

    public static RecipeFilter resultItemIs(Item[] items) {
        return (recipe, registryAccess) -> ArrayUtils.contains((Object[])items, (Object)recipe.value().getResultItem(registryAccess));
    }

    public static RecipeFilter resultItemIs(TagKey<Item> itemTag) {
        return (recipe, registryAccess) -> recipe.value().getResultItem(registryAccess).is(itemTag);
    }

    public static RecipeFilter resultItemMatches(ItemPredicate predicate) {
        return (recipe, registryAccess) -> predicate.test(recipe.value().getResultItem(registryAccess));
    }

    public static RecipeFilter idEquals(ResourceLocation id) {
        return (recipe, registryAccess) -> recipe.id().equals((Object)id);
    }

    public static RecipeFilter namespaceEquals(String group) {
        return (recipe, registryAccess) -> recipe.id().getNamespace().equals(group);
    }

    public static RecipeFilter isType(RecipeType<?> recipeType) {
        return (recipe, registryAccess) -> recipe.value().getType().equals((Object)recipeType);
    }

    public static RecipeFilter and(RecipeFilter ... filters) {
        return (recipe, registryAccess) -> {
            for (RecipeFilter filter : filters) {
                if (filter.shouldApply(recipe, registryAccess)) continue;
                return false;
            }
            return true;
        };
    }

    public static RecipeFilter or(RecipeFilter ... filters) {
        return (recipe, registryAccess) -> {
            for (RecipeFilter filter : filters) {
                if (!filter.shouldApply(recipe, registryAccess)) continue;
                return true;
            }
            return false;
        };
    }

    public static RecipeFilter not(RecipeFilter filter) {
        return (recipe, registryAccess) -> !filter.shouldApply(recipe, registryAccess);
    }
}

