/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.core.HolderLookup;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeHolder;
import net.minecraft.world.item.crafting.RecipeManager;
import net.player005.recipe_modification.api.Platform;
import net.player005.recipe_modification.api.RecipeHelper;
import net.player005.recipe_modification.impl.IngredientAccessor;
import net.player005.recipe_modification.impl.mixin.RecipeManagerAccessor;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.NotNullByDefault;

@NotNullByDefault
public class Platform_1_21
implements Platform {
    @Override
    public HolderLookup.Provider getRegistryAccess(RecipeManager recipeManager) {
        return ((RecipeManagerAccessor)recipeManager).getRegistries();
    }

    @Override
    public RecipeHolder<?> getRecipeByID(RecipeManager recipeManager, ResourceLocation id) {
        return ((RecipeManagerAccessor)recipeManager).getByName().get(id);
    }

    @Override
    public RecipeHelper getHelper() {
        return RecipeHelper_1_21.INSTANCE;
    }

    public static class RecipeHelper_1_21
    implements RecipeHelper {
        static RecipeHelper INSTANCE = new RecipeHelper_1_21();

        public static IngredientAccessor getAccessor(Ingredient ingredient) {
            return (IngredientAccessor)ingredient;
        }

        public static void replaceIngredientValues(Ingredient ingredient, Ingredient.Value[] values) {
            RecipeHelper_1_21.getAccessor(ingredient).replaceValues(values);
        }

        @Override
        public void addAlternative(Ingredient ingredient, Item ... items) {
            Object[] ingredientValues = (Ingredient.Value[])Arrays.stream(items).map(ItemStack::new).map(Ingredient.ItemValue::new).toArray(Ingredient.Value[]::new);
            Ingredient.Value[] newValues = (Ingredient.Value[])ArrayUtils.addAll((Object[])RecipeHelper_1_21.getAccessor(ingredient).getValues(), (Object[])ingredientValues);
            RecipeHelper_1_21.getAccessor(ingredient).replaceValues(newValues);
        }

        @Override
        public void addAlternative(Ingredient ingredient, TagKey<Item> itemTag) {
            RecipeHelper_1_21.replaceIngredientValues(ingredient, (Ingredient.Value[])ArrayUtils.add((Object[])RecipeHelper_1_21.getAccessor(ingredient).getValues(), (Object)new Ingredient.TagValue(itemTag)));
        }

        @Override
        public void addAlternative(Ingredient ingredient, Ingredient alternative) {
            RecipeHelper_1_21.replaceIngredientValues(ingredient, (Ingredient.Value[])ArrayUtils.addAll((Object[])RecipeHelper_1_21.getAccessor(ingredient).getValues(), (Object[])RecipeHelper_1_21.getAccessor(alternative).getValues()));
        }

        @Override
        public void removeAlternatives(Ingredient ingredient, Item ... items) {
            ArrayList<Ingredient.Value> newValues = new ArrayList<Ingredient.Value>(List.of(RecipeHelper_1_21.getAccessor(ingredient).getValues()));
            for (Item item : items) {
                newValues.removeIf(value -> {
                    ItemStack item1;
                    if (!(value instanceof Ingredient.ItemValue)) return false;
                    Ingredient.ItemValue $b$0 = (Ingredient.ItemValue)value;
                    try {
                        ItemStack patt1$temp;
                        item1 = patt1$temp = $b$0.item();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (!item1.is(item)) return false;
                    return true;
                });
            }
            RecipeHelper_1_21.getAccessor(ingredient).replaceValues(newValues.toArray(new Ingredient.Value[0]));
        }

        @Override
        public void removeAlternative(Ingredient ingredient, TagKey<Item> itemTag) {
            ArrayList<Ingredient.Value> newValues = new ArrayList<Ingredient.Value>(List.of(RecipeHelper_1_21.getAccessor(ingredient).getValues()));
            newValues.removeIf(value -> {
                TagKey tag;
                if (!(value instanceof Ingredient.TagValue)) return false;
                Ingredient.TagValue $b$0 = (Ingredient.TagValue)value;
                try {
                    TagKey patt1$temp;
                    tag = patt1$temp = $b$0.tag();
                }
                catch (Throwable throwable) {
                    throw new MatchException(throwable.toString(), throwable);
                }
                if (!itemTag.equals((Object)tag)) return false;
                return true;
            });
            RecipeHelper_1_21.getAccessor(ingredient).replaceValues(newValues.toArray(new Ingredient.Value[0]));
        }

        @Override
        public void replaceIngredient(Ingredient ingredient, Ingredient newIngredient) {
            RecipeHelper_1_21.replaceIngredientValues(ingredient, RecipeHelper_1_21.getAccessor(newIngredient).getValues());
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean isExactMatch(Ingredient ingredient, Item item) {
            Ingredient.Value[] valueArray = RecipeHelper_1_21.getAccessor(ingredient).getValues();
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ingredient.Value value = valueArray[n2];
                if (value instanceof Ingredient.ItemValue) {
                    ItemStack item1;
                    Ingredient.ItemValue itemValue = (Ingredient.ItemValue)value;
                    try {
                        ItemStack itemStack;
                        item1 = itemStack = itemValue.item();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (item1.is(item)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public boolean matchesTag(Ingredient ingredient, TagKey<Item> tag) {
            Ingredient.Value[] valueArray = RecipeHelper_1_21.getAccessor(ingredient).getValues();
            int n = valueArray.length;
            int n2 = 0;
            while (n2 < n) {
                Ingredient.Value value = valueArray[n2];
                if (value instanceof Ingredient.TagValue) {
                    TagKey tag1;
                    Ingredient.TagValue tagValue = (Ingredient.TagValue)value;
                    try {
                        TagKey tagKey;
                        tag1 = tagKey = tagValue.tag();
                    }
                    catch (Throwable throwable) {
                        throw new MatchException(throwable.toString(), throwable);
                    }
                    if (tag1.equals(tag)) {
                        return true;
                    }
                }
                ++n2;
            }
            return false;
        }
    }
}

