/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonElement;
import net.player005.recipe_modification.api.ModificationSet;
import net.player005.recipe_modification.api.RecipeModifier;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;
import net.player005.recipe_modification.serialization.RecipeModifierSerializer;

public abstract class ModificationSetSerializer {
    public static ModificationSet fromJson(JsonElement json) {
        if (json.isJsonArray()) {
            RecipeModifier[] modifiers = new RecipeModifier[json.getAsJsonArray().size()];
            for (int i = 0; i < modifiers.length; ++i) {
                modifiers[i] = RecipeModifierSerializer.fromJson(json.getAsJsonArray().get(i));
            }
            return new ModificationSet(modifiers);
        }
        if (json.isJsonObject()) {
            return new ModificationSet(RecipeModifierSerializer.fromJson(json));
        }
        throw new RecipeModifierParsingException("Invalid recipe modifier list: expected either an array of modifiers or a single modifier object.");
    }
}

