/*
 * Decompiled with CFR 0.152.
 */
package net.player005.recipe_modification.serialization;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.item.crafting.ShapelessRecipe;
import net.player005.recipe_modification.api.RecipeFilter;
import net.player005.recipe_modification.serialization.RecipeModifierParsingException;

public abstract class RecipeFilterSerializer {
    private static final Map<String, Function<JsonObject, RecipeFilter>> deserializers = new HashMap<String, Function<JsonObject, RecipeFilter>>();
    private static final ResourceLocation CRAFTING_SHAPED = ResourceLocation.parse((String)"crafting_shaped");
    private static final ResourceLocation CRAFTING_SHAPELESS = ResourceLocation.parse((String)"crafting_shapeless");

    public static RecipeFilter fromJson(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonPrimitive && (primitive = (JsonPrimitive)json).isString()) {
            return RecipeFilterSerializer.fromString(primitive.getAsString());
        }
        if (!json.isJsonObject()) {
            throw new RecipeModifierParsingException("Invalid recipe filter: expected an object");
        }
        JsonObject object = json.getAsJsonObject();
        String filterId = object.get("type").getAsString();
        if (!deserializers.containsKey(filterId)) {
            throw new RecipeModifierParsingException("Unknown recipe filter type: " + filterId);
        }
        return deserializers.get(filterId).apply(object);
    }

    private static RecipeFilter fromString(String string) {
        if (string.startsWith("!")) {
            return RecipeFilter.not(RecipeFilterSerializer.fromString(string.substring(1)));
        }
        if (string.startsWith("#")) {
            return RecipeFilter.resultItemIs((TagKey<Item>)TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)string.replace("#", ""))));
        }
        if (string.equals("*")) {
            return RecipeFilter.ALWAYS_APPLY;
        }
        if (!string.contains(":")) {
            return RecipeFilter.namespaceEquals(string);
        }
        ResourceLocation rl = ResourceLocation.tryParse((String)string);
        if (rl == null) {
            throw new RecipeModifierParsingException("Invalid resource location in shorthand recipe filter: " + string);
        }
        if (BuiltInRegistries.ITEM.containsKey(rl)) {
            return RecipeFilter.resultItemIs((Item)BuiltInRegistries.ITEM.get(rl));
        }
        return RecipeFilter.idEquals(ResourceLocation.parse((String)string));
    }

    private static RecipeFilter createFilterByResultItem(JsonElement json) {
        JsonPrimitive primitive;
        if (json instanceof JsonArray) {
            JsonArray array = (JsonArray)json;
            Item[] items = (Item[])array.asList().stream().map(jsonElement -> (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)jsonElement.getAsString()))).toArray(Item[]::new);
            return RecipeFilter.resultItemIs(items);
        }
        if (!(json instanceof JsonPrimitive) || !(primitive = (JsonPrimitive)json).isString()) {
            throw new RecipeModifierParsingException("invalid result item recipe filter: must be either string or array of strings: " + String.valueOf(json));
        }
        String str = json.getAsString();
        if (str.startsWith("#")) {
            TagKey itemTag = TagKey.create((ResourceKey)Registries.ITEM, (ResourceLocation)ResourceLocation.parse((String)str.replace("#", "")));
            return RecipeFilter.resultItemIs((TagKey<Item>)itemTag);
        }
        Item item = (Item)BuiltInRegistries.ITEM.get(ResourceLocation.parse((String)str));
        return RecipeFilter.resultItemIs(item);
    }

    public static void registerSerializer(String name, Function<JsonObject, RecipeFilter> deserializer) {
        deserializers.put(name, deserializer);
    }

    static {
        RecipeFilterSerializer.registerSerializer("all_recipes", json -> RecipeFilter.ALWAYS_APPLY);
        RecipeFilterSerializer.registerSerializer("accepting_ingredient", json -> {
            ItemStack item = (ItemStack)ItemStack.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("item")).getOrThrow();
            return RecipeFilter.acceptsIngredient(item);
        });
        RecipeFilterSerializer.registerSerializer("result_item_is", json -> {
            if (json.has("items")) {
                return RecipeFilterSerializer.createFilterByResultItem(json.get("items"));
            }
            if (json.has("item")) {
                return RecipeFilterSerializer.createFilterByResultItem(json.get("item"));
            }
            throw new RecipeModifierParsingException("'result_item_is' filter has no 'items' or 'item' defined - typo?");
        });
        RecipeFilterSerializer.registerSerializer("result_item_predicate", json -> {
            RecipeFilter itemFilter = null;
            if ((json = json.get("predicate").getAsJsonObject()).has("items")) {
                itemFilter = RecipeFilterSerializer.createFilterByResultItem(json.remove("items"));
            }
            ItemPredicate predicate = (ItemPredicate)ItemPredicate.CODEC.parse((DynamicOps)JsonOps.INSTANCE, json).getOrThrow();
            return itemFilter == null ? RecipeFilter.resultItemMatches(predicate) : RecipeFilter.and(itemFilter, RecipeFilter.resultItemMatches(predicate));
        });
        RecipeFilterSerializer.registerSerializer("id_equals", json -> {
            ResourceLocation id = ResourceLocation.parse((String)json.get("id").getAsString());
            return RecipeFilter.idEquals(id);
        });
        RecipeFilterSerializer.registerSerializer("namespace_equals", json -> {
            String namespace = json.get("namespace").getAsString();
            return RecipeFilter.namespaceEquals(namespace);
        });
        RecipeFilterSerializer.registerSerializer("and", json -> {
            JsonArray jsonFilters = json.getAsJsonArray("filters");
            ArrayList<RecipeFilter> filters = new ArrayList<RecipeFilter>();
            for (JsonElement filter : jsonFilters) {
                filters.add(RecipeFilterSerializer.fromJson(filter));
            }
            return RecipeFilter.and((RecipeFilter[])filters.toArray(RecipeFilter[]::new));
        });
        RecipeFilterSerializer.registerSerializer("or", json -> {
            JsonArray jsonFilters = json.getAsJsonArray("filters");
            ArrayList<RecipeFilter> filters = new ArrayList<RecipeFilter>();
            for (JsonElement filter : jsonFilters) {
                filters.add(RecipeFilterSerializer.fromJson(filter));
            }
            return RecipeFilter.or((RecipeFilter[])filters.toArray(RecipeFilter[]::new));
        });
        RecipeFilterSerializer.registerSerializer("not", json -> {
            RecipeFilter filter = RecipeFilterSerializer.fromJson(json.get("filter"));
            return RecipeFilter.not(filter);
        });
        RecipeFilterSerializer.registerSerializer("is_recipe_type", json -> {
            ResourceLocation rl = ResourceLocation.parse((String)json.get("recipe_type").getAsString());
            if (rl.equals((Object)CRAFTING_SHAPED)) {
                return (recipe, registries) -> recipe.value() instanceof ShapedRecipe;
            }
            if (rl.equals((Object)CRAFTING_SHAPELESS)) {
                return (recipe, registries) -> recipe.value() instanceof ShapelessRecipe;
            }
            RecipeType type = (RecipeType)BuiltInRegistries.RECIPE_TYPE.get(rl);
            if (type == null) {
                throw new RecipeModifierParsingException("Unknown recipe type: " + String.valueOf(rl));
            }
            return RecipeFilter.isType(type);
        });
    }
}

