/*
 * Decompiled with CFR 0.152.
 */
package dev.jaronline.cuttingdelight.server;

import dev.jaronline.cuttingdelight.CuttingDelight;
import dev.jaronline.cuttingdelight.client.gui.menu.CuttingBoardMenu;
import dev.jaronline.cuttingdelight.common.block.entity.CustomCuttingBoardBlockEntity;
import dev.jaronline.cuttingdelight.common.network.CutPayload;
import dev.jaronline.cuttingdelight.common.network.CuttingBoardEmptiedPayload;
import dev.jaronline.cuttingdelight.common.network.CuttingBoardFilledPayload;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;

public class ServerPayloadHandler {
    public static void handleCut(CutPayload payload, IPayloadContext context) {
        Player player = context.player();
        BlockEntity blockEntity = player.level().getBlockEntity(payload.blockPos());
        if (!(blockEntity instanceof CustomCuttingBoardBlockEntity)) {
            throw new IllegalArgumentException("Expected CustomCuttingBoardBlockEntity but found: " + blockEntity.getClass().getSimpleName());
        }
        CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)blockEntity;
        Recipe<?> recipe = payload.recipe();
        if (!(recipe instanceof CuttingBoardRecipe)) {
            throw new IllegalArgumentException("Expected CuttingBoardRecipe but found: " + payload.recipe().getClass().getSimpleName());
        }
        CuttingBoardRecipe cuttingRecipe = (CuttingBoardRecipe)recipe;
        cuttingBoardEntity.processStoredStackOrItemUsingTool(cuttingRecipe, player.getMainHandItem(), player);
        AbstractContainerMenu abstractContainerMenu = player.containerMenu;
        if (abstractContainerMenu instanceof CuttingBoardMenu) {
            CuttingBoardMenu cuttingBoardMenu = (CuttingBoardMenu)abstractContainerMenu;
            cuttingBoardMenu.updateInputItem(cuttingBoardEntity.getStoredItem());
        } else {
            CuttingDelight.LOGGER.warn("Player is not viewing CuttingBoardMenu while cutting on Cutting Board at {}", (Object)payload.blockPos());
        }
    }

    public static void handleCuttingBoardEmptied(CuttingBoardEmptiedPayload payload, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(payload.blockPos());
        if (!(blockEntity instanceof CustomCuttingBoardBlockEntity)) {
            throw new IllegalArgumentException("Expected CustomCuttingBoardBlockEntity but found: " + blockEntity.getClass().getSimpleName());
        }
        CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)blockEntity;
        cuttingBoardEntity.empty();
    }

    public static void handleCuttingBoardFilled(CuttingBoardFilledPayload payload, IPayloadContext context) {
        BlockEntity blockEntity = context.player().level().getBlockEntity(payload.blockPos());
        if (!(blockEntity instanceof CustomCuttingBoardBlockEntity)) {
            throw new IllegalArgumentException("Expected CustomCuttingBoardBlockEntity but found: " + blockEntity.getClass().getSimpleName());
        }
        CustomCuttingBoardBlockEntity cuttingBoardEntity = (CustomCuttingBoardBlockEntity)blockEntity;
        cuttingBoardEntity.addStack(payload.itemStack());
    }
}

