/*
 * Decompiled with CFR 0.152.
 */
package dev.lopyluna.dndesires.content.datagen;

import com.simibubi.create.api.data.recipe.ProcessingRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.DragonBreathingFanRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.EmptyingRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.FillingRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.FreezingFanRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.HydraulicRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.ItemApplicationRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.MixingRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.SandingFanRecipeGen;
import dev.lopyluna.dndesires.content.datagen.recipes.SeethingFanRecipeGen;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.CachedOutput;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.PackOutput;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.data.recipes.RecipeProvider;
import org.jetbrains.annotations.NotNull;

public class DesiresRecipeProvider
extends RecipeProvider {
    static final List<ProcessingRecipeGen<?, ?, ?>> GENERATORS = new ArrayList();
    protected final List<GeneratedRecipe> all = new ArrayList<GeneratedRecipe>();

    public DesiresRecipeProvider(PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        super(output, registries);
    }

    public static void registerAllProcessing(DataGenerator gen, PackOutput output, CompletableFuture<HolderLookup.Provider> registries) {
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new EmptyingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new FillingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new MixingRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new HydraulicRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new ItemApplicationRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new DragonBreathingFanRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new FreezingFanRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new SandingFanRecipeGen(output, registries));
        GENERATORS.add((ProcessingRecipeGen<?, ?, ?>)new SeethingFanRecipeGen(output, registries));
        gen.addProvider(true, new DataProvider(){

            @NotNull
            public String getName() {
                return "DnDesires's Processing Recipes";
            }

            @NotNull
            public CompletableFuture<?> run(@NotNull CachedOutput dc) {
                return CompletableFuture.allOf((CompletableFuture[])GENERATORS.stream().map(gen -> gen.run(dc)).toArray(CompletableFuture[]::new));
            }
        });
    }

    protected void buildRecipes(@NotNull RecipeOutput pRecipeOutput) {
        this.all.forEach(c -> c.register(pRecipeOutput));
    }

    protected GeneratedRecipe register(GeneratedRecipe recipe) {
        this.all.add(recipe);
        return recipe;
    }

    @FunctionalInterface
    public static interface GeneratedRecipe {
        public void register(RecipeOutput var1);
    }
}

