/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc;

import einstein.jmc.compat.AmendmentsCompat;
import einstein.jmc.data.BowlContents;
import einstein.jmc.data.effects.CakeEffectsManager;
import einstein.jmc.init.ModBlockEntityTypes;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.init.ModCreativeModeTabs;
import einstein.jmc.init.ModGameEvents;
import einstein.jmc.init.ModItems;
import einstein.jmc.init.ModMenuTypes;
import einstein.jmc.init.ModPackets;
import einstein.jmc.init.ModPotions;
import einstein.jmc.init.ModRecipes;
import einstein.jmc.init.ModTriggerTypes;
import einstein.jmc.init.ModVillagers;
import einstein.jmc.mixin.AdvancementAccessor;
import einstein.jmc.mixin.AdvancementRequirementsAccessor;
import einstein.jmc.platform.Services;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.Util;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTrigger;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.BlockPredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.ItemUsedOnLocationTrigger;
import net.minecraft.advancements.critereon.LocationPredicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageType;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JustMoreCakes {
    public static final String MOD_ID = "jmc";
    public static final String MOD_NAME = "Just More Cakes!";
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"Just More Cakes!");
    public static final ResourceKey<LootTable> CAKE_BAKER_GIFT = ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)JustMoreCakes.loc("gameplay/hero_of_the_village/cake_baker_gift"));
    public static final ResourceKey<DamageType> OBSIDIAN_CAKE_DAMAGE_TYPE = ResourceKey.create((ResourceKey)Registries.DAMAGE_TYPE, (ResourceLocation)JustMoreCakes.loc("obsidian_cake"));

    public static void init() {
        ModItems.init();
        ModBlocks.init();
        ModBlockEntityTypes.init();
        ModMenuTypes.init();
        ModRecipes.init();
        ModVillagers.init();
        ModPotions.init();
        ModCreativeModeTabs.init();
        ModGameEvents.init();
        ModPackets.init();
        ModTriggerTypes.init();
    }

    public static void commonSetup() {
        for (CakeVariant variant : CakeVariant.VARIANT_BY_CAKE.values()) {
            if (!variant.hasItem()) continue;
            Services.HOOKS.registerCompostable((ItemLike)variant.getItem().get(), 1.0f);
        }
        Services.HOOKS.registerCompostable((ItemLike)ModBlocks.CUPCAKE_VARIANT.getCake().get(), 0.25f);
        Services.HOOKS.registerCompostable((ItemLike)ModItems.CREAM_CHEESE.get(), 0.65f);
    }

    public static void onServerStarting(MinecraftServer server) {
        Util.registerVillageBuilding(server, "plains", "bakery_1", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        Util.registerVillageBuilding(server, "plains", "bakery_2", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        Util.registerVillageBuilding(server, "desert", "bakery_1", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        Util.registerVillageBuilding(server, "savanna", "bakery_1", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        Util.registerVillageBuilding(server, "snowy", "bakery_1", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        Util.registerVillageBuilding(server, "snowy", "bakery_2", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        Util.registerVillageBuilding(server, "taiga", "bakery_1", (Integer)ModCommonConfigs.CAKE_BAKERY_GENERATION_WEIGHT.get());
        JustMoreCakes.onDatapackSync(null, server, false);
    }

    public static void onDatapackSync(@Nullable ServerPlayer player, MinecraftServer server, boolean playerUpdate) {
        if (playerUpdate) {
            CakeEffectsManager.syncToPlayer(player);
            return;
        }
        CakeEffectsManager.loadCakeEffects();
        BowlContents.EMPTY.clear();
        if (((Boolean)ModCommonConfigs.DISABLE_DEFAULT_CAKE_RECIPE.get()).booleanValue()) {
            Util.removeRecipe(server.getRecipeManager(), JustMoreCakes.mcLoc("cake"), RecipeType.CRAFTING);
        }
        if (((Boolean)ModCommonConfigs.MODIFY_BIRTHDAY_SONG.get()).booleanValue()) {
            JustMoreCakes.modifyBirthdaySongAdvancement(server);
        }
    }

    private static void modifyBirthdaySongAdvancement(MinecraftServer server) {
        AdvancementHolder holder = server.getAdvancements().get(JustMoreCakes.mcLoc("husbandry/allay_deliver_cake_to_note_block"));
        if (holder != null) {
            Advancement advancement = holder.value();
            HashMap criteria = new HashMap(advancement.criteria());
            AdvancementRequirements requirements = advancement.requirements();
            ArrayList<List<String>> requirementsList = new ArrayList<List<String>>(requirements.requirements());
            ArrayList requirement = new ArrayList((Collection)requirementsList.getFirst());
            LocationPredicate.Builder locationPredicate = LocationPredicate.Builder.location().setBlock(BlockPredicate.Builder.block().of(new Block[]{Blocks.NOTE_BLOCK}));
            CakeFamily.REGISTERED_CAKE_FAMILIES.forEach((location, family) -> {
                String criteria_id = location.toString();
                criteria.put(criteria_id, new Criterion((CriterionTrigger)CriteriaTriggers.ALLAY_DROP_ITEM_ON_BLOCK, (CriterionTriggerInstance)((ItemUsedOnLocationTrigger.TriggerInstance)ItemUsedOnLocationTrigger.TriggerInstance.allayDropItemOnBlock((LocationPredicate.Builder)locationPredicate, (ItemPredicate.Builder)ItemPredicate.Builder.item().of(new ItemLike[]{(ItemLike)family.getBaseItem().get()})).triggerInstance())));
                requirement.add(criteria_id);
            });
            requirementsList.set(0, requirement);
            ((AdvancementRequirementsAccessor)requirements).setRequirements(requirementsList);
            ((AdvancementAccessor)advancement).setCriteria(criteria);
        }
    }

    public static InteractionResult blockClicked(Player player, Level level, InteractionHand hand, BlockHitResult hitResult) {
        boolean canUse;
        ItemStack stack = player.getItemInHand(hand);
        BlockPos pos = hitResult.getBlockPos();
        BlockState state = level.getBlockState(pos);
        boolean bl = canUse = !player.isSecondaryUseActive() || player.getMainHandItem().isEmpty() && player.getOffhandItem().isEmpty();
        if (stack.is(Blocks.CAKE.asItem()) && canUse && Services.PLATFORM.isModLoaded("amendments")) {
            return AmendmentsCompat.cakeUsedOnBlock(player, level, hand, hitResult);
        }
        return InteractionResult.PASS;
    }

    public static void livingEntityJump(Entity entity) {
        Player player;
        if (entity instanceof Player && (player = (Player)entity).hasEffect(ModPotions.BOUNCING_EFFECT.get())) {
            player.push(0.0, (double)0.15f, 0.0);
        }
    }

    public static void livingEntityTick(Level level, LivingEntity entity) {
        RandomSource random = entity.getRandom();
        if (entity.hasEffect(ModPotions.BOUNCING_EFFECT.get()) && entity.verticalCollision && entity.onGround() && !entity.isSleeping()) {
            float f = 0.65f;
            if (entity.hasEffect(MobEffects.JUMP)) {
                f += 0.1f * (float)(entity.getEffect(MobEffects.JUMP).getAmplifier() + 1);
            }
            entity.push(0.0, (double)f, 0.0);
            entity.playSound(SoundEvents.SLIME_SQUISH, 1.0f, 1.0f);
            if (level.isClientSide) {
                for (int i = 0; i < 8; ++i) {
                    float f1 = random.nextFloat() * ((float)Math.PI * 2);
                    float f2 = random.nextFloat() * 0.5f + 0.5f;
                    float f3 = Mth.sin((float)f1) * 1.0f * 0.5f * f2;
                    float f4 = Mth.cos((float)f1) * 1.0f * 0.5f * f2;
                    level.addParticle((ParticleOptions)ParticleTypes.ITEM_SLIME, entity.getX() + (double)f3, entity.getY(), entity.getZ() + (double)f4, 0.0, 0.0, 0.0);
                }
            }
        }
    }

    public static ResourceLocation loc(String string) {
        return ResourceLocation.fromNamespaceAndPath((String)MOD_ID, (String)string);
    }

    public static ResourceLocation mcLoc(String string) {
        return ResourceLocation.withDefaultNamespace((String)string);
    }
}

