/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.advancement.criterian;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.datafixers.util.Either;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import einstein.jmc.block.CakeEffectsHolder;
import einstein.jmc.init.ModTriggerTypes;
import einstein.jmc.registration.family.CakeFamily;
import java.util.Optional;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.block.Block;

public class CakeEatenTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final Codec<TriggerInstance> BLOCK = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::predicate), (App)CakeEffectsHolder.BLOCK_CODEC.fieldOf("block").forGetter(TriggerInstance::holder)).apply((Applicative)instance, TriggerInstance::new));
    private static final Codec<TriggerInstance> FAMILY = RecordCodecBuilder.create(instance -> instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(TriggerInstance::predicate), (App)CakeFamily.CODEC.fieldOf("family").forGetter(trigger -> (CakeFamily)trigger.holder())).apply((Applicative)instance, TriggerInstance::new));
    public static final Codec<TriggerInstance> CODEC = Codec.xor(BLOCK, FAMILY).xmap(either -> (TriggerInstance)either.map(trigger -> trigger, trigger -> trigger), trigger -> {
        if (trigger.holder() instanceof Block) {
            return Either.left((Object)trigger);
        }
        if (trigger.holder() instanceof CakeFamily) {
            return Either.right((Object)trigger);
        }
        throw new UnsupportedOperationException("This is neither a block nor a family");
    });

    public void trigger(ServerPlayer player, CakeEffectsHolder holder) {
        super.trigger(player, trigger -> trigger.matches(holder));
    }

    public Codec<TriggerInstance> codec() {
        return CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> predicate, CakeEffectsHolder holder) implements SimpleCriterionTrigger.SimpleInstance
    {
        public static Criterion<TriggerInstance> cakeEaten(CakeEffectsHolder holder) {
            return ModTriggerTypes.CAKE_EATEN.get().createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.empty(), holder));
        }

        public boolean matches(CakeEffectsHolder holder) {
            return this.holder().equals(holder);
        }

        public Optional<ContextAwarePredicate> player() {
            return this.predicate;
        }
    }
}

