/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block;

import com.mojang.serialization.MapCodec;
import einstein.jmc.block.entity.CakeOvenBlockEntity;
import einstein.jmc.init.ModBlockEntityTypes;
import einstein.jmc.platform.Services;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;

public class CakeOvenBlock
extends BaseEntityBlock {
    public static final MapCodec<CakeOvenBlock> CODEC = CakeOvenBlock.simpleCodec(CakeOvenBlock::new);
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.FACING;
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public CakeOvenBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CakeOvenBlockEntity) {
            CakeOvenBlockEntity cakeOvenBlockEntity = (CakeOvenBlockEntity)blockEntity;
            Services.HOOKS.openMenu((ServerPlayer)player, cakeOvenBlockEntity);
        }
        return InteractionResult.CONSUME;
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        return (BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)context.getHorizontalDirection().getOpposite());
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean moved) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CakeOvenBlockEntity) {
                CakeOvenBlockEntity cakeOvenBlockEntity = (CakeOvenBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    Containers.dropContents((Level)level, (BlockPos)pos, (Container)cakeOvenBlockEntity);
                    cakeOvenBlockEntity.getRecipesToAwardAndPopExperience((ServerLevel)level, Vec3.atCenterOf((Vec3i)pos));
                    cakeOvenBlockEntity.dropRemainingItems(level, pos);
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, moved);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        return (BlockState)state.setValue((Property)FACING, (Comparable)rotation.rotate((Direction)state.getValue((Property)FACING)));
    }

    public BlockState mirror(BlockState state, Mirror mirror) {
        return state.rotate(mirror.getRotation((Direction)state.getValue((Property)FACING)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FACING, LIT});
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            double d0 = (double)pos.getX() + 0.5;
            double d1 = pos.getY();
            double d2 = (double)pos.getZ() + 0.5;
            if (random.nextDouble() < 0.1) {
                level.playLocalSound(d0, d1, d2, SoundEvents.SMOKER_SMOKE, SoundSource.BLOCKS, 1.0f, 1.0f, false);
            }
            Direction direction = (Direction)state.getValue((Property)FACING);
            Direction.Axis axis = direction.getAxis();
            double d3 = random.nextDouble() * 0.6 - 0.3;
            double d4 = axis == Direction.Axis.X ? (double)direction.getStepX() * 0.52 : d3;
            double d5 = random.nextDouble() * 6.0 / 16.0;
            double d6 = axis == Direction.Axis.Z ? (double)direction.getStepZ() * 0.52 : d3;
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0 + d4, d1 + d5, d2 + d6, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.SMOKE, d0, d1 + 1.1, d2, 0.0, 0.0, 0.0);
            level.addParticle((ParticleOptions)ParticleTypes.FLAME, d0 + d4, d1 + d5, d2 + d6, 0.0, 0.0, 0.0);
        }
    }

    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CakeOvenBlockEntity(pos, state);
    }

    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return level.isClientSide ? null : CakeOvenBlock.createTickerHelper(blockEntityType, ModBlockEntityTypes.CAKE_OVEN.get(), CakeOvenBlockEntity::serverTick);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

