/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block;

import com.mojang.serialization.MapCodec;
import einstein.jmc.block.entity.CakeStandBlockEntity;
import einstein.jmc.data.packs.ModBlockTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CakeStandBlock
extends BaseEntityBlock {
    private static final MapCodec<CakeStandBlock> CODEC = CakeStandBlock.simpleCodec(CakeStandBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)7.0, (double)15.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)6.0, (double)1.0, (double)15.0, (double)15.0, (double)15.0), Block.box((double)0.0, (double)5.0, (double)0.0, (double)16.0, (double)6.0, (double)16.0), Block.box((double)4.0, (double)1.0, (double)4.0, (double)12.0, (double)5.0, (double)12.0), Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0)});

    public CakeStandBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CakeStandBlockEntity cakeStandBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CakeStandBlockEntity && (cakeStandBlockEntity = (CakeStandBlockEntity)blockEntity).isEmpty()) {
            BlockItem blockItem;
            Block block;
            BlockState storedState;
            Item item;
            if (!stack.isEmpty() && (item = stack.getItem()) instanceof BlockItem && (storedState = (block = (blockItem = (BlockItem)item).getBlock()).defaultBlockState()).is(ModBlockTags.CAKE_STAND_STORABLES)) {
                if (level.isClientSide) {
                    SoundType soundType = storedState.getSoundType();
                    CakeStandBlock.playBlockSound(level, pos, player, soundType.getPlaceSound(), soundType);
                    return ItemInteractionResult.CONSUME;
                }
                if (!player.isCreative()) {
                    stack.shrink(1);
                }
                level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
                cakeStandBlockEntity.setStoredBlock(block);
                return ItemInteractionResult.SUCCESS;
            }
            return ItemInteractionResult.CONSUME;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CakeStandBlockEntity) {
            CakeStandBlockEntity cakeStandBlockEntity = (CakeStandBlockEntity)blockEntity;
            if (level.isClientSide) {
                if (!cakeStandBlockEntity.isEmpty()) {
                    SoundType soundType = cakeStandBlockEntity.getStoredBlock().defaultBlockState().getSoundType();
                    CakeStandBlock.playBlockSound(level, pos, player, soundType.getBreakSound(), soundType);
                }
                return InteractionResult.CONSUME;
            }
            if (!player.isCreative()) {
                Block.popResourceFromFace((Level)level, (BlockPos)pos, (Direction)Direction.UP, (ItemStack)new ItemStack((ItemLike)cakeStandBlockEntity.getStoredBlock().asItem()));
            }
            level.gameEvent((Holder)GameEvent.BLOCK_CHANGE, pos, GameEvent.Context.of((Entity)player, (BlockState)state));
            cakeStandBlockEntity.setStoredBlock(Blocks.AIR);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    private static void playBlockSound(Level level, BlockPos pos, Player player, SoundEvent soundEvent, SoundType soundType) {
        level.playSound(player, pos, soundEvent, SoundSource.BLOCKS, (soundType.getVolume() + 1.0f) / 2.0f, soundType.getPitch() * 0.8f);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            CakeStandBlockEntity cakeStandBlockEntity;
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CakeStandBlockEntity && !(cakeStandBlockEntity = (CakeStandBlockEntity)blockEntity).isEmpty()) {
                Containers.dropItemStack((Level)level, (double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (ItemStack)new ItemStack((ItemLike)cakeStandBlockEntity.getStoredBlock()));
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        CakeStandBlockEntity cakeStandBlockEntity;
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CakeStandBlockEntity && !(cakeStandBlockEntity = (CakeStandBlockEntity)blockEntity).isEmpty()) {
            return 15;
        }
        return 0;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CakeStandBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

