/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block;

import com.mojang.serialization.MapCodec;
import einstein.jmc.block.entity.CeramicBowlBlockEntity;
import einstein.jmc.init.ModItems;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CeramicBowlBlock
extends BaseEntityBlock {
    private static final MapCodec<CeramicBowlBlock> CODEC = CeramicBowlBlock.simpleCodec(CeramicBowlBlock::new);
    private static final VoxelShape SHAPE = Shapes.or((VoxelShape)Block.box((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.0, (double)0.0, (double)2.0, (double)14.0, (double)9.0, (double)3.0), Block.box((double)2.0, (double)0.0, (double)13.0, (double)14.0, (double)9.0, (double)14.0), Block.box((double)2.0, (double)0.0, (double)3.0, (double)3.0, (double)9.0, (double)13.0), Block.box((double)13.0, (double)0.0, (double)3.0, (double)14.0, (double)9.0, (double)13.0)});
    public static final IntegerProperty FILL_LEVEL = IntegerProperty.create((String)"fill_level", (int)0, (int)4);

    public CeramicBowlBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)FILL_LEVEL, (Comparable)Integer.valueOf(0)));
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return SHAPE;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (stack.isEmpty()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CeramicBowlBlockEntity) {
            CeramicBowlBlockEntity ceramicBowlBlockEntity = (CeramicBowlBlockEntity)blockEntity;
            if (level.isClientSide) {
                return ItemInteractionResult.CONSUME;
            }
            if (stack.is(ModItems.WHISK.get())) {
                if (ceramicBowlBlockEntity.tryCraft(player)) {
                    stack.hurtAndBreak(1, (LivingEntity)player, hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND);
                    return ItemInteractionResult.SUCCESS;
                }
            } else if (ceramicBowlBlockEntity.addItem(player, player.isCreative() ? stack.copy() : stack)) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof CeramicBowlBlockEntity) {
            CeramicBowlBlockEntity ceramicBowlBlockEntity = (CeramicBowlBlockEntity)blockEntity;
            if (level.isClientSide) {
                return InteractionResult.CONSUME;
            }
            if ((Integer)state.getValue((Property)FILL_LEVEL) == 4) {
                return ceramicBowlBlockEntity.takeResult(player) ? InteractionResult.SUCCESS : InteractionResult.PASS;
            }
            if (ceramicBowlBlockEntity.takeItem(player)) {
                return InteractionResult.SUCCESS;
            }
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public void onRemove(BlockState state, Level level, BlockPos pos, BlockState newState, boolean movedByPiston) {
        if (!state.is(newState.getBlock())) {
            BlockEntity blockEntity = level.getBlockEntity(pos);
            if (blockEntity instanceof CeramicBowlBlockEntity) {
                CeramicBowlBlockEntity ceramicBowlBlockEntity = (CeramicBowlBlockEntity)blockEntity;
                if (level instanceof ServerLevel) {
                    ceramicBowlBlockEntity.dropItems(level, pos);
                }
                level.updateNeighbourForOutputSignal(pos, (Block)this);
            }
            super.onRemove(state, level, pos, newState, movedByPiston);
        }
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{FILL_LEVEL});
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return AbstractContainerMenu.getRedstoneSignalFromBlockEntity((BlockEntity)level.getBlockEntity(pos));
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new CeramicBowlBlockEntity(pos, state);
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }
}

