/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake;

import einstein.jmc.block.CakeEffectsHolder;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.init.ModClientConfigs;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.init.ModTriggerTypes;
import einstein.jmc.platform.Services;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.CakeUtil;
import einstein.jmc.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.DustColorTransitionOptions;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CandleBlock;
import net.minecraft.world.level.block.SculkSensorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.SculkSensorPhase;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseCakeBlock
extends Block
implements CakeEffectsHolder {
    public static final IntegerProperty BITES = BlockStateProperties.BITES;
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)3.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)13.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};
    private final boolean allowsCandles;
    private final boolean canAlwaysEat;
    private final int slices;
    private CakeVariant variant;
    @Nullable
    private CakeEffects cakeEffects;

    protected BaseCakeBlock(CakeVariant variant, int slices) {
        this(variant.getCakeProperties(), variant.allowsCandles(), variant.canAlwaysEat(), slices);
        this.variant = variant;
    }

    public BaseCakeBlock(CakeVariant variant) {
        this(variant, 6);
    }

    public BaseCakeBlock(BlockBehaviour.Properties properties, boolean allowsCandles, boolean canAlwaysEat, int slices) {
        super(properties);
        this.allowsCandles = allowsCandles;
        this.canAlwaysEat = canAlwaysEat;
        this.slices = slices;
        if (this.hasBites()) {
            this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)this.getBites(), (Comparable)Integer.valueOf(0)));
        }
    }

    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return this.getShapeByBite(state)[(Integer)state.getValue((Property)this.getBites())];
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        Block block;
        Item item = stack.getItem();
        CakeFamily family = this.getFamily();
        if (this.allowsCandles && stack.is(ItemTags.CANDLES) && CakeUtil.isUneaten(state, pos, level) && (block = Block.byItem((Item)item)) instanceof CandleBlock) {
            if (!player.isCreative()) {
                stack.shrink(1);
            }
            level.playSound(null, pos, SoundEvents.CAKE_ADD_CANDLE, SoundSource.BLOCKS, 1.0f, 1.0f);
            BaseCandleCakeBlock candleCake = this.variant.getCandleCakeByCandle().get(block).get();
            BlockState newState = candleCake.defaultBlockState();
            level.setBlockAndUpdate(pos, newState);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_CHANGE, pos);
            player.awardStat(Stats.ITEM_USED.get((Object)item));
            this.afterCandlePlaced(level, state, pos, candleCake);
            Block.pushEntitiesUp((BlockState)state, (BlockState)newState, (LevelAccessor)level, (BlockPos)pos);
            return ItemInteractionResult.SUCCESS;
        }
        if (family != null && this.isBaseVariant() && stack.is(family.getBaseCake().get().asItem()) && CakeUtil.convertToTwoTiered(family, state, pos, level, player, stack, false).consumesAction()) {
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public void afterCandlePlaced(Level level, BlockState state, BlockPos pos, BaseCandleCakeBlock candleCake) {
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (level.isClientSide) {
            if (this.eat(level, pos, state, player).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (player.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return this.eat(level, pos, state, player);
    }

    public InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        CakeEffects effects;
        if (!player.canEat(this.canAlwaysEat)) {
            return InteractionResult.PASS;
        }
        if (Services.PLATFORM.isModLoaded("cakechomps") && !BITES.equals((Object)this.getBites())) {
            ItemStack stack = state.getBlock().getCloneItemStack((LevelReader)level, pos, state);
            player.spawnItemParticles(stack, 16);
            player.playSound(player.getEatingSound(stack), 0.5f + 0.5f * (float)Util.RANDOM.nextInt(2), (Util.RANDOM.nextFloat() - Util.RANDOM.nextFloat()) * 0.2f + 1.0f);
        }
        player.awardStat(Stats.EAT_CAKE_SLICE);
        player.getFoodData().eat(this.getNutrition(), this.getSaturationModifier());
        state = this.eatActions(player, pos, state);
        if (!level.isClientSide() && (effects = this.justMoreCakes$getCakeEffects()) != null) {
            this.applyEffects(player, effects);
        }
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModTriggerTypes.CAKE_EATEN.get().trigger(serverPlayer, this);
        }
        int bite = (Integer)state.getValue((Property)this.getBites());
        level.gameEvent((Entity)player, (Holder)GameEvent.EAT, pos);
        if (bite < this.getSlices()) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)this.getBites(), (Comparable)Integer.valueOf(bite + 1)));
        } else {
            level.removeBlock(pos, false);
            level.gameEvent((Entity)player, (Holder)GameEvent.BLOCK_DESTROY, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void applyEffects(Player player, CakeEffects effects) {
        for (MobEffectInstance effectInstance : effects.mobEffects()) {
            Util.applyEffect(effectInstance, (LivingEntity)player);
        }
    }

    public BlockState eatActions(Player player, BlockPos pos, BlockState state) {
        if (CakeUtil.inFamily(state, ModBlocks.FIREY_CAKE_FAMILY)) {
            player.setRemainingFireTicks(((Integer)ModCommonConfigs.FIREY_CAKE_ON_FIRE_DUR.get()).intValue());
        } else if (CakeUtil.inFamily(state, ModBlocks.ICE_CAKE_FAMILY)) {
            player.clearFire();
        } else if (CakeUtil.inFamily(state, ModBlocks.CHORUS_CAKE_FAMILY)) {
            Util.teleportRandomly((LivingEntity)player, (Double)ModCommonConfigs.CHORUS_CAKE_TELEPORT_RADIUS.get(), false);
        } else if (CakeUtil.inFamily(state, ModBlocks.ENDER_CAKE_FAMILY) && Util.teleportRandomly((LivingEntity)player, (Double)ModCommonConfigs.ENDER_CAKE_TELEPORT_RADIUS.get(), (Boolean)ModClientConfigs.ENDER_CAKE_PARTICLES.get())) {
            player.playSound(SoundEvents.PLAYER_TELEPORT, 1.0f, 1.0f);
        }
        return state;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor accessor, BlockPos pos, BlockPos neighborPos) {
        return direction == Direction.DOWN && !state.canSurvive((LevelReader)accessor, pos) ? Blocks.AIR.defaultBlockState() : super.updateShape(state, direction, neighborState, accessor, pos, neighborPos);
    }

    public boolean canSurvive(BlockState state, LevelReader reader, BlockPos pos) {
        return reader.getBlockState(pos.below()).isSolid();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{this.getBites()});
    }

    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return CakeUtil.getComparatorOutput(state);
    }

    public boolean hasAnalogOutputSignal(BlockState state) {
        return true;
    }

    public boolean isPathfindable(BlockState state, PathComputationType computationType) {
        return false;
    }

    public ItemStack getCloneItemStack(LevelReader reader, BlockPos pos, BlockState state) {
        ItemStack stack = super.getCloneItemStack(reader, pos, state);
        if (stack.isEmpty() && this.getFamily() != null) {
            return new ItemStack((ItemLike)this.getFamily().getBaseCake().get());
        }
        return stack;
    }

    public void animateTick(BlockState state, Level level, BlockPos pos, RandomSource random) {
        Direction direction;
        if (CakeUtil.inFamily(state, ModBlocks.ENDER_CAKE_FAMILY) && ((Boolean)ModClientConfigs.ENDER_CAKE_PARTICLES.get()).booleanValue()) {
            for (int i = 0; i < 3; ++i) {
                int xSign = random.nextInt(2) * 2 - 1;
                int zSign = random.nextInt(2) * 2 - 1;
                double x = (double)pos.getX() + 0.5 + 0.25 * (double)xSign;
                double y = (float)pos.getY() + random.nextFloat();
                double z = (double)pos.getZ() + 0.5 + 0.25 * (double)zSign;
                double XSpeed = random.nextFloat() * (float)xSign;
                double YSpeed = ((double)random.nextFloat() - 0.5) * 0.125;
                double ZSpeed = random.nextFloat() * (float)zSign;
                level.addParticle((ParticleOptions)ParticleTypes.PORTAL, x, y, z, XSpeed, YSpeed, ZSpeed);
            }
        } else if (CakeUtil.inFamily(state, ModBlocks.REDSTONE_CAKE_FAMILY) && ((Boolean)ModClientConfigs.REDSTONE_CAKE_PARTICLES.get()).booleanValue()) {
            for (int i = 0; i < 2; ++i) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = (double)pos.getY() + random.nextDouble() * 0.5 + 0.25;
                double z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)DustParticleOptions.REDSTONE, x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (CakeUtil.inFamily(state, ModBlocks.LAVA_CAKE_FAMILY) && ((Boolean)ModClientConfigs.LAVA_CAKE_PARTICLES.get()).booleanValue()) {
            if (random.nextInt(10) == 0) {
                double x = (double)pos.getX() + random.nextDouble();
                double y = pos.getY() + 1;
                double z = (double)pos.getZ() + random.nextDouble();
                level.addParticle((ParticleOptions)ParticleTypes.LAVA, x, y, z, 0.0, 0.0, 0.0);
            }
        } else if (CakeUtil.inFamily(state, ModBlocks.SCULK_CAKE_FAMILY) && SculkSensorBlock.getPhase((BlockState)state) == SculkSensorPhase.ACTIVE && (direction = Direction.getRandom((RandomSource)random)) != Direction.UP && direction != Direction.DOWN) {
            double x = (double)pos.getX() + 0.5 + (direction.getStepX() == 0 ? 0.5 - random.nextDouble() : (double)direction.getStepX() * 0.6);
            double y = (double)pos.getY() + 0.25;
            double z = (double)pos.getZ() + 0.5 + (direction.getStepZ() == 0 ? 0.5 - random.nextDouble() : (double)direction.getStepZ() * 0.6);
            double ySpeed = (double)random.nextFloat() * 0.04;
            level.addParticle((ParticleOptions)DustColorTransitionOptions.SCULK_TO_REDSTONE, x, y, z, 0.0, ySpeed, 0.0);
        }
    }

    public boolean hasBites() {
        return this.getBites() != null && this.getSlices() > 0;
    }

    @Nullable
    public IntegerProperty getBites() {
        return BITES;
    }

    public VoxelShape[] getShapeByBite(BlockState state) {
        return SHAPE_BY_BITE;
    }

    public int getSlices() {
        return this.slices;
    }

    public CakeVariant getVariant() {
        return this.variant;
    }

    @Nullable
    public CakeFamily getFamily() {
        return this.variant.getFamily();
    }

    public boolean isBaseVariant() {
        return this.variant.getType() == CakeVariant.Type.BASE;
    }

    @Override
    @Nullable
    public CakeEffects justMoreCakes$getCakeEffects() {
        if (this.cakeEffects != null) {
            return this.cakeEffects;
        }
        if (this.getFamily() != null) {
            return this.getFamily().justMoreCakes$getCakeEffects();
        }
        return null;
    }

    @Override
    public void justMoreCakes$setCakeEffects(@Nullable CakeEffects cakeEffects) {
        this.cakeEffects = cakeEffects;
    }

    public int getNutrition() {
        if (this.variant != null) {
            return this.variant.getNutrition();
        }
        return 2;
    }

    public float getSaturationModifier() {
        if (this.variant != null) {
            return this.variant.getSaturationModifier();
        }
        return 0.1f;
    }
}

