/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.registration.family.CakeFamily;
import einstein.jmc.util.CakeUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class BaseTwoTieredCakeBlock
extends BaseCakeBlock {
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)10);
    protected static final VoxelShape[] SHAPE_BY_BITE = new VoxelShape[]{Shapes.or((VoxelShape)Block.box((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)4.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)6.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)8.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Shapes.or((VoxelShape)Block.box((double)10.0, (double)8.0, (double)2.0, (double)14.0, (double)15.0, (double)14.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)), Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)4.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)7.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)9.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0), Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)8.0, (double)15.0)};

    public BaseTwoTieredCakeBlock(CakeVariant builder) {
        super(builder, 10);
    }

    @Override
    @Nullable
    public IntegerProperty getBites() {
        return BITES;
    }

    @Override
    public VoxelShape[] getShapeByBite(BlockState state) {
        return SHAPE_BY_BITE;
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        CakeFamily family = this.getFamily();
        if (family != null && stack.is(family.getBaseCake().get().asItem())) {
            if (CakeUtil.convertToThreeTiered(family, state, pos, level, player, stack, false).consumesAction()) {
                return ItemInteractionResult.SUCCESS;
            }
            if ((Integer)state.getValue((Property)this.getBites()) == 5 && CakeUtil.convertToTwoTiered(family, state, pos, level, player, stack, true).consumesAction()) {
                return ItemInteractionResult.SUCCESS;
            }
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }
}

