/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake;

import einstein.jmc.block.cake.BaseThreeTieredCakeBlock;
import einstein.jmc.block.cake.ObsidianCakeBlock;
import einstein.jmc.init.ModTriggerTypes;
import einstein.jmc.registration.CakeVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ObsidianThreeTieredCakeBlock
extends BaseThreeTieredCakeBlock {
    public ObsidianThreeTieredCakeBlock(CakeVariant builder) {
        super(builder);
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        return state.getValue((Property)HALF) == DoubleBlockHalf.LOWER ? SHAPE_BY_BITE_LOWER[5] : SHAPE_BY_BITE_UPPER[0];
    }

    @Override
    public InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        ObsidianCakeBlock.damage(level, player);
        level.setBlockAndUpdate(pos, state);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModTriggerTypes.CAKE_EATEN.get().trigger(serverPlayer, this);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{HALF});
    }

    @Override
    public int getAnalogOutputSignal(BlockState state, Level level, BlockPos pos) {
        return 16;
    }

    @Override
    public IntegerProperty getBites() {
        return null;
    }

    @Override
    public int getSlices() {
        return 0;
    }
}

