/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.entity.TNTCakeBlockEntity;
import einstein.jmc.init.ModCommonConfigs;
import einstein.jmc.registration.CakeVariant;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class TNTCakeBlock
extends BaseCakeBlock
implements EntityBlock {
    public TNTCakeBlock(CakeVariant builder) {
        super(builder);
    }

    @Override
    public InteractionResult eat(Level level, BlockPos pos, BlockState state, Player player) {
        InteractionResult result = super.eat(level, pos, state, player);
        TNTCakeBlock.explode(level, pos);
        return result;
    }

    public void neighborChanged(BlockState state, Level level, BlockPos pos, Block neighborBlock, BlockPos neighborPos, boolean movedByPiston) {
        TNTCakeBlock.explodeIfAllowed(level, pos);
    }

    public void onPlace(BlockState state, Level level, BlockPos pos, BlockState oldState, boolean movedByPiston) {
        TNTCakeBlock.explodeIfAllowed(level, pos);
    }

    public static void explodeIfAllowed(Level level, BlockPos pos) {
        if (((Boolean)ModCommonConfigs.EFFECTED_BY_REDSTONE.get()).booleanValue() && level.hasNeighborSignal(pos)) {
            TNTCakeBlock.explode(level, pos);
        }
    }

    public static void explode(Level level, BlockPos pos) {
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof TNTCakeBlockEntity) {
            TNTCakeBlockEntity tntCakeBlockEntity = (TNTCakeBlockEntity)blockEntity;
            tntCakeBlockEntity.explode();
        }
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new TNTCakeBlockEntity(pos, state);
    }
}

