/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.cake.candle;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.util.Util;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;

public class SlimeCandleCakeBlock
extends BaseCandleCakeBlock {
    public SlimeCandleCakeBlock(BaseCakeBlock parentCake, Block candle, BlockBehaviour.Properties properties) {
        super(parentCake, candle, properties);
    }

    public void fallOn(Level level, BlockState state, BlockPos pos, Entity entity, float fallDistance) {
        if (entity.isSuppressingBounce() || this.isAboveCake(pos, entity)) {
            super.fallOn(level, state, pos, entity, fallDistance);
        } else {
            entity.causeFallDamage(fallDistance, 0.0f, level.damageSources().fall());
        }
    }

    public void updateEntityAfterFallOn(BlockGetter getter, Entity entity) {
        if (entity.isSuppressingBounce() || this.isAboveCake(entity.getOnPosLegacy(), entity)) {
            super.updateEntityAfterFallOn(getter, entity);
        } else {
            Util.bounceUp(entity);
        }
    }

    public void stepOn(Level level, BlockPos pos, BlockState state, Entity entity) {
        double d0 = Math.abs(entity.getDeltaMovement().y);
        if (d0 < 0.1 && !entity.isSteppingCarefully() && !this.isAboveCake(pos, entity)) {
            double d1 = 0.4 + d0 * 0.2;
            entity.setDeltaMovement(entity.getDeltaMovement().multiply(d1, 1.0, d1));
        }
        super.stepOn(level, pos, state, entity);
    }

    private boolean isAboveCake(BlockPos pos, Entity entity) {
        return entity.getY() - (double)pos.getY() > this.getCandleHeight();
    }
}

