/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.block.entity;

import einstein.jmc.init.ModBlockEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.game.ClientGamePacketListener;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.Nullable;

public class CakeStandBlockEntity
extends BlockEntity {
    private Block storedBlock = Blocks.AIR;

    public CakeStandBlockEntity(BlockPos pos, BlockState state) {
        super(ModBlockEntityTypes.CAKE_STAND.get(), pos, state);
    }

    @Nullable
    public Packet<ClientGamePacketListener> getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.create((BlockEntity)this);
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider provider) {
        CompoundTag tag = new CompoundTag();
        this.saveStoredBlock(tag);
        return tag;
    }

    public void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ResourceLocation blockKey = ResourceLocation.tryParse((String)tag.getString("StoredBlock"));
        if (blockKey != null) {
            this.storedBlock = (Block)BuiltInRegistries.BLOCK.get(blockKey);
            this.setChanged();
        }
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        this.saveStoredBlock(tag);
    }

    private void saveStoredBlock(CompoundTag tag) {
        tag.putString("StoredBlock", BuiltInRegistries.BLOCK.getKey((Object)this.storedBlock).toString());
    }

    public Block getStoredBlock() {
        return this.storedBlock;
    }

    public void setStoredBlock(Block storedBlock) {
        this.storedBlock = storedBlock;
        this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        this.setChanged();
    }

    public boolean isEmpty() {
        return this.storedBlock == null || this.storedBlock.equals(Blocks.AIR);
    }
}

