/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jade.elements;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.compat.jade.ModJadePlugin;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.resources.language.I18n;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.Vec2;
import org.jetbrains.annotations.Nullable;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.Element;
import snownee.jade.api.ui.IDisplayHelper;

public class FoodPointsSpriteElement
extends Element {
    private static final ResourceLocation FOOD_EMPTY_SPRITE = JustMoreCakes.mcLoc("hud/food_empty");
    private static final ResourceLocation FOOD_HALF_SPRITE = JustMoreCakes.mcLoc("hud/food_half");
    private static final ResourceLocation FOOD_FULL_SPRITE = JustMoreCakes.mcLoc("hud/food_full");
    private static final int SPRITE_SIZE = 9;
    private static final int SPACING = 10;
    private final IPluginConfig config;
    private final ModJadePlugin.CakeInfoDisplayType displayType;
    private final int slices;
    private final int nutrition;
    private final Component sliceText;
    private final Font font;

    public FoodPointsSpriteElement(IPluginConfig config, int slices, int nutrition) {
        this.font = Minecraft.getInstance().font;
        this.displayType = (ModJadePlugin.CakeInfoDisplayType)config.getEnum(ModJadePlugin.DISPLAY_TYPE);
        this.sliceText = Component.translatable((String)"jade.plugin_jmc.count", (Object[])new Object[]{slices});
        this.config = config;
        this.slices = this.displayType == ModJadePlugin.CakeInfoDisplayType.PER_SLICE ? 1 : slices;
        this.nutrition = nutrition;
    }

    public Vec2 getSize() {
        int nutritionPerSlice = this.nutrition * this.slices;
        boolean isEven = nutritionPerSlice % 2 == 0;
        int maxIconsPerLine = this.config.getInt(ModJadePlugin.FOOD_ICONS_PER_LINE);
        int totalFoodPoints = (isEven ? nutritionPerSlice : nutritionPerSlice + 1) / 2;
        int foodPointsPerLine = Math.min(maxIconsPerLine, totalFoodPoints);
        int lineCount = (int)Math.ceil((float)totalFoodPoints / (float)maxIconsPerLine);
        int width = 9 * foodPointsPerLine;
        if (this.displayType == ModJadePlugin.CakeInfoDisplayType.PER_SLICE) {
            width += this.font.width((FormattedText)this.sliceText);
        }
        return new Vec2((float)width, (float)(10 * lineCount));
    }

    public void render(GuiGraphics guiGraphics, float x, float y, float maxX, float maxY) {
        IDisplayHelper helper = IDisplayHelper.get();
        int nutritionPerSlice = this.nutrition * this.slices;
        boolean isEven = nutritionPerSlice % 2 == 0;
        int maxIconsPerLine = this.config.getInt(ModJadePlugin.FOOD_ICONS_PER_LINE);
        int totalFoodPoints = (isEven ? nutritionPerSlice : nutritionPerSlice + 1) / 2;
        int foodPointsPerLine = Math.min(maxIconsPerLine, totalFoodPoints);
        int xOffset = 0;
        int yOffset = 0;
        int i = 1;
        if (!isEven) {
            FoodPointsSpriteElement.blitFoodPoint(guiGraphics, helper, FOOD_HALF_SPRITE, x + (float)xOffset, y + (float)yOffset);
            xOffset = 9;
            ++i;
        }
        while (i <= totalFoodPoints) {
            FoodPointsSpriteElement.blitFoodPoint(guiGraphics, helper, FOOD_FULL_SPRITE, x + (float)xOffset, y + (float)yOffset);
            xOffset += 9;
            if (i % foodPointsPerLine == 0) {
                yOffset += 10;
                xOffset = 0;
            }
            ++i;
        }
        if (this.displayType == ModJadePlugin.CakeInfoDisplayType.PER_SLICE) {
            helper.drawText(guiGraphics, (FormattedText)this.sliceText, x + (float)((i - 2) * 9) + 10.0f, y, IThemeHelper.get().getNormalColor());
        }
    }

    private static void blitFoodPoint(GuiGraphics guiGraphics, IDisplayHelper helper, ResourceLocation overlaySprite, float x, float y) {
        helper.blitSprite(guiGraphics, FOOD_EMPTY_SPRITE, (int)x, (int)y, 9, 9);
        helper.blitSprite(guiGraphics, overlaySprite, (int)x, (int)y, 9, 9);
    }

    @Nullable
    public String getMessage() {
        return I18n.get((String)"narration.jade.jmc.nutrition", (Object[])new Object[]{this.nutrition});
    }
}

