/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jade.providers;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.block.cake.candle.BaseCandleCakeBlock;
import einstein.jmc.compat.jade.ModJadePlugin;
import einstein.jmc.compat.jade.elements.FoodPointsSpriteElement;
import einstein.jmc.util.CakeUtil;
import java.text.DecimalFormat;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElement;
import snownee.jade.api.ui.IElementHelper;

public class CakeNourishmentProvider
implements IBlockComponentProvider {
    private static final DecimalFormat FORMATTER = new DecimalFormat("0.##");

    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        Block block = accessor.getBlock();
        if (block instanceof BaseCakeBlock) {
            BaseCakeBlock cake = (BaseCakeBlock)block;
            CakeNourishmentProvider.addNourishmentInfo(tooltip, config, cake.getSlices() + 1, cake.getNutrition(), cake.getSaturationModifier());
        } else if (block instanceof BaseCandleCakeBlock) {
            BaseCandleCakeBlock candleCake = (BaseCandleCakeBlock)block;
            BaseCakeBlock parentCake = candleCake.getParentCake();
            CakeNourishmentProvider.addNourishmentInfo(tooltip, config, parentCake.getSlices() + 1, parentCake.getNutrition(), parentCake.getSaturationModifier());
        } else if (block == Blocks.CAKE || CakeUtil.getVanillaCandleCakes().contains((Object)block)) {
            CakeNourishmentProvider.addNourishmentInfo(tooltip, config, 7, 2, 0.1f);
        }
    }

    private static void addNourishmentInfo(ITooltip tooltip, IPluginConfig config, int slices, int nutrition, float saturationModifier) {
        if (config.get(ModJadePlugin.SHOW_NUTRITION) && nutrition > 0) {
            tooltip.add((IElement)new FoodPointsSpriteElement(config, slices, nutrition));
        }
        if (config.get(ModJadePlugin.SHOW_SATURATION) && saturationModifier > 0.0f && nutrition > 0) {
            if (config.getEnum(ModJadePlugin.DISPLAY_TYPE) == ModJadePlugin.CakeInfoDisplayType.TOTAL) {
                saturationModifier *= (float)slices;
            }
            tooltip.add((IElement)IElementHelper.get().text((Component)Component.translatable((String)"jade.plugin_jmc.saturation", (Object[])new Object[]{FORMATTER.format((float)nutrition * saturationModifier * 2.0f)})));
        }
    }

    public ResourceLocation getUid() {
        return ModJadePlugin.CAKE_NOURISHMENT;
    }
}

