/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jade.providers;

import einstein.jmc.block.entity.CakeOvenBlockEntity;
import einstein.jmc.compat.jade.ModJadePlugin;
import einstein.jmc.util.CakeOvenConstants;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.phys.Vec2;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.ui.IElementHelper;

public class CakeOvenProvider
implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>,
CakeOvenConstants {
    public void appendTooltip(ITooltip tooltip, BlockAccessor accessor, IPluginConfig config) {
        CompoundTag tag = accessor.getServerData();
        if (tag.contains("CookTime")) {
            int cookTime = tag.getInt("CookTime");
            int cookTimeTotal = tag.getInt("CookTimeTotal");
            NonNullList items = NonNullList.withSize((int)6, (Object)ItemStack.EMPTY);
            IElementHelper helper = IElementHelper.get();
            ContainerHelper.loadAllItems((CompoundTag)tag, (NonNullList)items, (HolderLookup.Provider)accessor.getLevel().registryAccess());
            tooltip.add(helper.item((ItemStack)items.getFirst()));
            for (int i = 1; i < 4; ++i) {
                tooltip.append(helper.item((ItemStack)items.get(i)));
            }
            tooltip.append(helper.item((ItemStack)items.get(4)));
            tooltip.append(helper.spacer(4, 0));
            tooltip.append(helper.progress((float)cookTime / (float)cookTimeTotal).translate(new Vec2(-2.0f, 0.0f)));
            tooltip.append(helper.item((ItemStack)items.get(5)));
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor accessor) {
        CakeOvenBlockEntity blockEntity = (CakeOvenBlockEntity)accessor.getBlockEntity();
        if (!blockEntity.isEmpty()) {
            RegistryAccess registryAccess = accessor.getLevel().registryAccess();
            ContainerHelper.saveAllItems((CompoundTag)tag, blockEntity.getItems(), (HolderLookup.Provider)registryAccess);
            CompoundTag savedTag = blockEntity.saveWithoutMetadata((HolderLookup.Provider)registryAccess);
            tag.putInt("CookTime", savedTag.getInt("CookTime"));
            tag.putInt("CookTimeTotal", savedTag.getInt("CookTimeTotal"));
        }
    }

    public ResourceLocation getUid() {
        return ModJadePlugin.CAKE_OVEN;
    }
}

