/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jei;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import einstein.jmc.compat.jei.ModJEIPlugin;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import einstein.jmc.util.CakeOvenConstants;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.drawable.IDrawableAnimated;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class CakeOvenRecipeCategory
implements IRecipeCategory<CakeOvenRecipe>,
CakeOvenConstants {
    private final IDrawable background;
    private final IDrawable icon;
    private final IDrawableAnimated flame;
    private final Component title;
    private final LoadingCache<Integer, IDrawableAnimated> cachedArrows;

    public CakeOvenRecipeCategory(final IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ModJEIPlugin.TEXTURE, 0, 0, 133, 44);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModBlocks.CAKE_OVEN.get()));
        this.title = Component.translatable((String)"gui.jei.jmc.category.cake_oven");
        this.flame = guiHelper.createAnimatedDrawable(guiHelper.createDrawable(ModJEIPlugin.TEXTURE, 133, 0, 14, 14), 300, IDrawableAnimated.StartDirection.TOP, true);
        this.cachedArrows = CacheBuilder.newBuilder().maximumSize(25L).build((CacheLoader)new CacheLoader<Integer, IDrawableAnimated>(this){

            public IDrawableAnimated load(Integer cookTime) {
                return guiHelper.drawableBuilder(ModJEIPlugin.TEXTURE, 133, 14, 24, 17).buildAnimated(cookTime.intValue(), IDrawableAnimated.StartDirection.LEFT, false);
            }
        });
    }

    public RecipeType<CakeOvenRecipe> getRecipeType() {
        return ModJEIPlugin.CAKE_OVEN;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public Component getTitle() {
        return this.title;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, CakeOvenRecipe recipe, IFocusGroup focuses) {
        Level level = (Level)Objects.requireNonNull(Minecraft.getInstance().level);
        IRecipeSlotBuilder[] ingredientSlots = new IRecipeSlotBuilder[]{builder.addSlot(RecipeIngredientRole.INPUT, 34, 5), builder.addSlot(RecipeIngredientRole.INPUT, 52, 5), builder.addSlot(RecipeIngredientRole.INPUT, 34, 23), builder.addSlot(RecipeIngredientRole.INPUT, 52, 23)};
        for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            ingredientSlots[i].addIngredients((Ingredient)recipe.getIngredients().get(i));
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 112, 14).addItemStack(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
        builder.setShapeless();
    }

    private IDrawableAnimated getArrow(CakeOvenRecipe recipe) {
        int cookTime = recipe.getCookingTime();
        if (cookTime <= 0) {
            cookTime = 200;
        }
        return (IDrawableAnimated)this.cachedArrows.getUnchecked((Object)cookTime);
    }

    public void draw(CakeOvenRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        this.flame.draw(guiGraphics, 1, 4);
        this.getArrow(recipe).draw(guiGraphics, 75, 13);
        this.drawExperienceText(recipe, guiGraphics);
        this.drawCookTimeText(recipe, guiGraphics);
    }

    private void drawExperienceText(CakeOvenRecipe recipe, GuiGraphics guiGraphics) {
        float experience = recipe.getExperience();
        if (experience > 0.0f) {
            MutableComponent experienceText = Component.translatable((String)"gui.jei.jmc.category.cake_oven.experience", (Object[])new Object[]{Float.valueOf(experience)});
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, (Component)experienceText, this.background.getWidth() - font.width((FormattedText)experienceText) - 13, 0, -8355712, false);
        }
    }

    private void drawCookTimeText(CakeOvenRecipe recipe, GuiGraphics guiGraphics) {
        int cookTime = recipe.getCookingTime();
        if (cookTime > 0) {
            int cookTimeSeconds = cookTime / 20;
            MutableComponent cookTimeText = Component.translatable((String)"gui.jei.jmc.category.cake_oven.time.seconds", (Object[])new Object[]{cookTimeSeconds});
            Font font = Minecraft.getInstance().font;
            guiGraphics.drawString(font, (Component)cookTimeText, this.background.getWidth() - font.width((FormattedText)cookTimeText), 37, -8355712, false);
        }
    }
}

