/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.jei;

import einstein.jmc.compat.jei.ModJEIPlugin;
import einstein.jmc.init.ModItems;
import einstein.jmc.item.crafting.MixingRecipe;
import java.util.Objects;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.HolderLookup;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class MixingRecipeCategory
implements IRecipeCategory<MixingRecipe> {
    private final IDrawable background;
    private final IDrawable icon;
    private final Component title;

    public MixingRecipeCategory(IGuiHelper guiHelper) {
        this.background = guiHelper.createDrawable(ModJEIPlugin.TEXTURE, 0, 44, 110, 59);
        this.icon = guiHelper.createDrawableItemStack(new ItemStack((ItemLike)ModItems.WHISK.get()));
        this.title = Component.translatable((String)"gui.jei.jmc.category.mixing");
    }

    public RecipeType<MixingRecipe> getRecipeType() {
        return ModJEIPlugin.MIXING_RECIPE;
    }

    public Component getTitle() {
        return this.title;
    }

    public IDrawable getBackground() {
        return this.background;
    }

    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(IRecipeLayoutBuilder builder, MixingRecipe recipe, IFocusGroup focuses) {
        Level level = (Level)Objects.requireNonNull(Minecraft.getInstance().level);
        IRecipeSlotBuilder[] ingredientSlots = new IRecipeSlotBuilder[]{builder.addSlot(RecipeIngredientRole.INPUT, 1, 5), builder.addSlot(RecipeIngredientRole.INPUT, 19, 5), builder.addSlot(RecipeIngredientRole.INPUT, 1, 23), builder.addSlot(RecipeIngredientRole.INPUT, 19, 23)};
        for (int i = 0; i < recipe.getIngredients().size(); ++i) {
            ingredientSlots[i].addIngredients((Ingredient)recipe.getIngredients().get(i));
        }
        builder.addSlot(RecipeIngredientRole.CATALYST, 47, 39).addItemStack(new ItemStack((ItemLike)ModItems.WHISK.get()));
        builder.addSlot(RecipeIngredientRole.OUTPUT, 78, 13).addItemStack(recipe.getResultItem((HolderLookup.Provider)level.registryAccess()));
        builder.setShapeless();
    }

    public void draw(MixingRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics guiGraphics, double mouseX, double mouseY) {
        Font font = Minecraft.getInstance().font;
        MutableComponent text = Component.translatable((String)"gui.jei.jmc.category.mixing.uses", (Object[])new Object[]{recipe.getMixingTime()});
        guiGraphics.drawString(font, (Component)text, 68, 44, -8355712, false);
    }
}

