/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.compat.rei;

import einstein.jmc.compat.rei.ModREICommonPlugin;
import einstein.jmc.item.crafting.CakeOvenRecipe;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.SimpleGridMenuDisplay;
import me.shedaniel.rei.api.common.display.basic.BasicDisplay;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.registry.RecipeManagerContext;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeHolder;

public class CakeOvenDisplay
extends BasicDisplay
implements SimpleGridMenuDisplay {
    private final float experience;
    private final int cookingTime;

    public CakeOvenDisplay(RecipeHolder<CakeOvenRecipe> holder) {
        this(EntryIngredients.ofIngredients(((CakeOvenRecipe)holder.value()).getIngredients()), Collections.singletonList(EntryIngredients.of((ItemStack)((CakeOvenRecipe)holder.value()).getResultItem((HolderLookup.Provider)CakeOvenDisplay.registryAccess()))), holder, ((CakeOvenRecipe)holder.value()).getExperience(), ((CakeOvenRecipe)holder.value()).getCookingTime());
    }

    public CakeOvenDisplay(List<EntryIngredient> ingredients, List<EntryIngredient> results, CompoundTag tag) {
        this(ingredients, results, RecipeManagerContext.getInstance().byId(tag, "location"), tag.getFloat("experience"), tag.getInt("cookingTime"));
    }

    public CakeOvenDisplay(List<EntryIngredient> ingredients, List<EntryIngredient> results, RecipeHolder<?> holder, float experience, int cookingTime) {
        super(CakeOvenDisplay.fillWithEmpty(ingredients), results, Optional.ofNullable(holder).map(RecipeHolder::id));
        this.experience = experience;
        this.cookingTime = cookingTime;
    }

    public static List<EntryIngredient> fillWithEmpty(List<EntryIngredient> inputs) {
        if (inputs.size() == 4) {
            return inputs;
        }
        ArrayList<EntryIngredient> ingredients = new ArrayList<EntryIngredient>(inputs);
        for (int i = 0; i < 4 - inputs.size(); ++i) {
            ingredients.add(EntryIngredients.of((ItemStack)ItemStack.EMPTY));
        }
        return ingredients;
    }

    public int getWidth() {
        return 2;
    }

    public int getHeight() {
        return 2;
    }

    public CategoryIdentifier<?> getCategoryIdentifier() {
        return ModREICommonPlugin.CAKE_OVEN;
    }

    public float getExperience() {
        return this.experience;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public static BasicDisplay.Serializer<CakeOvenDisplay> serializer() {
        return BasicDisplay.Serializer.ofRecipeLess(CakeOvenDisplay::new, (display, tag) -> {
            tag.putFloat("experience", display.getExperience());
            tag.putInt("cookingTime", display.getCookingTime());
        });
    }
}

