/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data;

import einstein.jmc.item.crafting.MixingRecipe;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.core.NonNullList;
import net.minecraft.data.recipes.RecipeBuilder;
import net.minecraft.data.recipes.RecipeCategory;
import net.minecraft.data.recipes.RecipeOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public class MixingRecipeBuilder
implements RecipeBuilder {
    private final RecipeCategory category;
    private final NonNullList<Ingredient> ingredients;
    private final Item result;
    private final ResourceLocation contents;
    private final int count;
    private final int mixingTime;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();

    private MixingRecipeBuilder(RecipeCategory category, NonNullList<Ingredient> ingredients, ItemLike result, ResourceLocation contents, int count, int mixingTime) {
        this.category = category;
        this.ingredients = ingredients;
        this.result = result.asItem();
        this.contents = contents;
        this.count = count;
        this.mixingTime = mixingTime;
    }

    public static MixingRecipeBuilder mixing(RecipeCategory category, ItemLike result, ResourceLocation contents, int mixingTime, ItemLike ... ingredients) {
        return MixingRecipeBuilder.mixing(category, result, contents, 1, mixingTime, ingredients);
    }

    public static MixingRecipeBuilder mixing(RecipeCategory category, ItemLike result, ResourceLocation contents, int count, int mixingTime, ItemLike ... ingredients) {
        return MixingRecipeBuilder.mixing(category, result, contents, count, mixingTime, (Ingredient[])Arrays.stream(ingredients).map(xva$0 -> Ingredient.of((ItemLike[])new ItemLike[]{xva$0})).toArray(Ingredient[]::new));
    }

    public static MixingRecipeBuilder mixing(RecipeCategory category, ItemLike result, ResourceLocation contents, int mixingTime, Ingredient ... ingredients) {
        return MixingRecipeBuilder.mixing(category, result, contents, 1, mixingTime, ingredients);
    }

    public static MixingRecipeBuilder mixing(RecipeCategory category, ItemLike result, ResourceLocation contents, int count, int mixingTime, Ingredient ... ingredients) {
        if (mixingTime < 1) {
            throw new IllegalStateException("mixingTime must be a positive number");
        }
        if (ingredients.length > 4) {
            throw new IllegalStateException("Too many ingredients for mixing recipe. The max is 4");
        }
        NonNullList ingredientsList = NonNullList.create();
        Collections.addAll(ingredientsList, ingredients);
        return new MixingRecipeBuilder(category, (NonNullList<Ingredient>)ingredientsList, result, contents, count, mixingTime);
    }

    public RecipeBuilder unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public RecipeBuilder group(@Nullable String group) {
        return this;
    }

    public Item getResult() {
        return this.result;
    }

    public void save(RecipeOutput output, ResourceLocation recipeId) {
        if (this.criteria.isEmpty()) {
            throw new IllegalStateException("No way of obtaining recipe: " + String.valueOf(recipeId));
        }
        Advancement.Builder builder = output.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)recipeId)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)recipeId)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        output.accept(recipeId, (Recipe)new MixingRecipe(this.ingredients, new ItemStack((ItemLike)this.result, this.count), this.contents, this.mixingTime), builder.build(recipeId.withPrefix("recipes/" + this.category.getFolderName() + "/")));
    }
}

