/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.effects;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import com.mojang.authlib.GameProfile;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import commonnetwork.api.Dispatcher;
import einstein.jmc.JustMoreCakes;
import einstein.jmc.block.CakeEffectsHolder;
import einstein.jmc.data.effects.CakeEffects;
import einstein.jmc.network.clientbound.ClientboundCakeEffectsPacket;
import einstein.jmc.util.Util;
import java.io.BufferedReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Holder;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.effect.MobEffectInstance;

public class CakeEffectsManager {
    public static final String EFFECTS_DIRECTORY = "jmc/cake_effect";
    private static final List<CakeEffects> RAW_CAKE_EFFECTS = new ArrayList<CakeEffects>();
    private static final List<CakeEffects> CAKE_EFFECTS = new ArrayList<CakeEffects>();

    public static void syncToPlayer(ServerPlayer player) {
        Dispatcher.sendToClient((Object)new ClientboundCakeEffectsPacket(CAKE_EFFECTS), (ServerPlayer)player);
        GameProfile profile = player.getGameProfile();
        JustMoreCakes.LOGGER.info("Sending cake effects to {} ({})", (Object)profile.getName(), (Object)profile.getId());
    }

    public static void loadCakeEffects() {
        HashMap<CakeEffectsHolder, Map> newCakeEffects = new HashMap<CakeEffectsHolder, Map>();
        RAW_CAKE_EFFECTS.forEach(cakeEffects -> {
            CakeEffectsHolder holder = cakeEffects.holder();
            cakeEffects.mobEffects().forEach(effectInstance -> {
                Holder effect = effectInstance.getEffect();
                int duration = effectInstance.getDuration();
                int amplifier = effectInstance.getAmplifier();
                if (newCakeEffects.containsKey(holder)) {
                    Map combinedEffects = (Map)newCakeEffects.get(holder);
                    if (combinedEffects.containsKey(effect)) {
                        Pair pair = (Pair)combinedEffects.get(effect);
                        int currentDuration = (Integer)pair.getSecond();
                        combinedEffects.put(effect, Pair.of((Object)(duration == -1 || currentDuration == -1 ? -1 : Math.max(duration, currentDuration)), (Object)Math.max(amplifier, (Integer)pair.getSecond())));
                    } else {
                        combinedEffects.put(effect, Pair.of((Object)duration, (Object)amplifier));
                    }
                } else {
                    newCakeEffects.put(holder, new HashMap<Holder, Pair>(Map.of(effect, Pair.of((Object)duration, (Object)amplifier))));
                }
            });
        });
        RAW_CAKE_EFFECTS.clear();
        CakeEffectsManager.clearCakeEffects();
        newCakeEffects.forEach((holder, effects) -> {
            ArrayList<MobEffectInstance> instances = new ArrayList<MobEffectInstance>();
            effects.forEach((mobEffect, pair) -> instances.add(new MobEffectInstance(mobEffect, ((Integer)pair.getFirst()).intValue(), ((Integer)pair.getSecond()).intValue())));
            CakeEffectsManager.setEffectsOnHolder(new CakeEffects((CakeEffectsHolder)holder, (List<MobEffectInstance>)instances));
        });
    }

    public static void clearCakeEffects() {
        CAKE_EFFECTS.forEach(cakeEffects -> cakeEffects.holder().clear());
        CAKE_EFFECTS.clear();
    }

    public static void setEffectsOnHolder(CakeEffects cakeEffects) {
        cakeEffects.holder().justMoreCakes$setCakeEffects(cakeEffects);
        CAKE_EFFECTS.add(cakeEffects);
    }

    public static void deserializeCakeEffects(ResourceManager manager) {
        Map locations = manager.listResources(EFFECTS_DIRECTORY, location -> location.getPath().endsWith(".json"));
        locations.forEach((location, resource) -> {
            try (BufferedReader reader = resource.openAsReader();){
                JsonObject object = (JsonObject)GsonHelper.fromJson((Gson)Util.GSON, (Reader)reader, JsonObject.class);
                CakeEffects.CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)object).resultOrPartial(error -> JustMoreCakes.LOGGER.error("Failed to decode cake effect with json id {} - Error: {}", location, error)).ifPresent(RAW_CAKE_EFFECTS::add);
            }
            catch (Exception exception) {
                JustMoreCakes.LOGGER.error("Error occurred while loading resource json {}", location, (Object)exception);
            }
        });
        JustMoreCakes.LOGGER.info("Loaded {} cake effects", (Object)RAW_CAKE_EFFECTS.size());
    }
}

