/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.packs;

import einstein.jmc.JustMoreCakes;
import einstein.jmc.advancement.criterian.CakeEatenTrigger;
import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.util.Util;
import java.util.Comparator;
import java.util.TreeSet;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.AdvancementType;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Blocks;

public class ModAdvancements {
    private static final AdvancementHolder PLANT_SEEDS_DUMMY = new AdvancementHolder(JustMoreCakes.mcLoc("husbandry/plant_seed"), null);

    public static void generate(Consumer<AdvancementHolder> consumer) {
        AdvancementHolder craftCake = ModAdvancements.addCakes(Advancement.Builder.advancement().parent(PLANT_SEEDS_DUMMY).requirements(AdvancementRequirements.Strategy.OR).display((ItemLike)Blocks.CAKE.asItem(), ModAdvancements.translatable("craft_cake.title"), ModAdvancements.translatable("craft_cake.description"), null, AdvancementType.TASK, true, true, false)).save(consumer, JustMoreCakes.loc("husbandry/craft_cake").toString());
        ModAdvancements.addCakes(Advancement.Builder.advancement().parent(craftCake).display((ItemLike)ModBlocks.CHOCOLATE_CAKE_FAMILY.getBaseCake().get(), ModAdvancements.translatable("craft_all_cakes.title"), ModAdvancements.translatable("craft_all_cakes.description"), null, AdvancementType.CHALLENGE, true, true, false).rewards(AdvancementRewards.Builder.experience((int)100))).save(consumer, JustMoreCakes.loc("husbandry/craft_all_cakes").toString());
        Advancement.Builder.advancement().parent(craftCake).requirements(AdvancementRequirements.Strategy.OR).display((ItemLike)ModBlocks.OBSIDIAN_CAKE_FAMILY.getBaseCake().get(), ModAdvancements.translatable("eat_obsidian_cake.title"), ModAdvancements.translatable("eat_obsidian_cake.description"), null, AdvancementType.TASK, true, true, false).addCriterion(ModBlocks.OBSIDIAN_CAKE_FAMILY.getBaseCakeName() + "_eaten", CakeEatenTrigger.TriggerInstance.cakeEaten(ModBlocks.OBSIDIAN_CAKE_FAMILY)).save(consumer, JustMoreCakes.loc("husbandry/eat_obsidian_cake").toString());
    }

    private static Advancement.Builder addCakes(Advancement.Builder advancement) {
        advancement.addCriterion("cake", InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{Blocks.CAKE}).build()}));
        TreeSet<Supplier> cakes = new TreeSet<Supplier>(Comparator.comparing(o -> ((BaseCakeBlock)o.get()).getVariant().getCakeName()));
        cakes.addAll(CakeVariant.VARIANT_BY_CAKE.keySet());
        for (Supplier cake : cakes) {
            BaseCakeBlock cakeBlock = (BaseCakeBlock)cake.get();
            if (!cakeBlock.isBaseVariant()) continue;
            Item cakeItem = cakeBlock.asItem();
            advancement.addCriterion(Util.getBlockId(cakeBlock).getPath(), InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{ItemPredicate.Builder.item().of(new ItemLike[]{cakeItem}).build()}));
        }
        return advancement;
    }

    private static Component translatable(String name) {
        return Component.translatable((String)("advancements.husbandry.jmc." + name));
    }
}

