/*
 * Decompiled with CFR 0.152.
 */
package einstein.jmc.data.packs;

import einstein.jmc.block.cake.BaseCakeBlock;
import einstein.jmc.init.ModBlocks;
import einstein.jmc.registration.CakeVariant;
import einstein.jmc.util.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.core.HolderLookup;
import net.minecraft.data.loot.BlockLootSubProvider;
import net.minecraft.world.flag.FeatureFlags;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.storage.loot.LootPool;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.entries.LootItem;
import net.minecraft.world.level.storage.loot.entries.LootPoolEntryContainer;
import net.minecraft.world.level.storage.loot.providers.number.ConstantValue;
import net.minecraft.world.level.storage.loot.providers.number.NumberProvider;

public class ModBlockLootTables
extends BlockLootSubProvider {
    private static final List<Block> KNOWN_BLOCKS = new ArrayList<Block>();

    public ModBlockLootTables(HolderLookup.Provider provider) {
        super(Set.of(), FeatureFlags.REGISTRY.allFlags(), provider);
    }

    protected void generate() {
        this.dropSelf(ModBlocks.CAKE_OVEN.get());
        this.dropSelf(ModBlocks.CAKE_STAND.get());
        this.dropSelf(ModBlocks.CERAMIC_BOWL.get());
        CakeVariant.VARIANT_BY_CAKE.forEach((cake, variant) -> {
            BaseCakeBlock cakeBlock = (BaseCakeBlock)cake.get();
            CakeVariant.Type variantType = variant.getType();
            KNOWN_BLOCKS.add(cakeBlock);
            switch (variantType) {
                case BASE: {
                    this.add(cakeBlock, Util.addDropWhenCakeSpatulaPool(LootTable.lootTable(), cakeBlock));
                    variant.getCandleCakeByCandle().forEach((candle, candleCake) -> {
                        this.add((Block)candleCake.get(), block -> Util.addDropWhenCakeSpatulaPool(ModBlockLootTables.createCandleCakeDrops((Block)candle), cakeBlock));
                        KNOWN_BLOCKS.add((Block)candleCake.get());
                    });
                    break;
                }
                case TWO_TIERED: {
                    Block baseCake = variant.getFamily().getBaseCake().get();
                    this.add(cakeBlock, Util.addDropWhenCakeSpatulaPool(LootTable.lootTable(), baseCake, 2));
                    variant.getCandleCakeByCandle().forEach((candle, candleCake) -> {
                        this.add((Block)candleCake.get(), block -> Util.addDropWhenCakeSpatulaPool(ModBlockLootTables.createCandleCakeDrops((Block)candle), baseCake, 2));
                        KNOWN_BLOCKS.add((Block)candleCake.get());
                    });
                    break;
                }
                case THREE_TIERED: {
                    Block baseCake = variant.getFamily().getBaseCake().get();
                    this.add(cakeBlock, block -> Util.addDropWhenCakeSpatulaPool(LootTable.lootTable(), block, baseCake, 3, true));
                    variant.getCandleCakeByCandle().forEach((candle, candleCake) -> {
                        this.add((Block)candleCake.get(), block -> Util.addDropWhenCakeSpatulaPool(LootTable.lootTable().withPool(Util.addHalfConditionToPool(LootPool.lootPool().setRolls((NumberProvider)ConstantValue.exactly((float)1.0f)).add((LootPoolEntryContainer.Builder)LootItem.lootTableItem((ItemLike)candle)), block)), block, baseCake, 3, true));
                        KNOWN_BLOCKS.add((Block)candleCake.get());
                    });
                }
            }
        });
    }

    protected Iterable<Block> getKnownBlocks() {
        KNOWN_BLOCKS.add(ModBlocks.CAKE_OVEN.get());
        KNOWN_BLOCKS.add(ModBlocks.CAKE_STAND.get());
        KNOWN_BLOCKS.add(ModBlocks.CERAMIC_BOWL.get());
        return KNOWN_BLOCKS;
    }
}

